% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{get.url.params}
\alias{get.url.params}
\title{Extract from the data frame with the access log the urls query strings parameters and values.}
\usage{
get.url.params(dfLog)
}
\arguments{
\item{dfLog}{a dataframe with the access log. Can be load with read.apache.access.log or read.multiple.apache.access.log.}
}
\value{
a structure of data frames with query strings parameters for each url of the log
}
\description{
The function supports multivalued parameters, but does not support parameters inside urls yet.
}
\examples{
#Load a log which the urls have query strings
path = system.file("examples", "access_log_with_query_string.log", package = "ApacheLogProcessor")

#Read a log file with combined format and return it in a data frame
df = read.apache.access.log(path, format = "common")

#Clear the urls with parameters inside
params <- get.url.params(df)

}
\author{
Diogo Silveira Mendonca
}
