% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_sync_nodes.R
\name{Af_sync_nodes}
\alias{Af_sync_nodes}
\title{Function to synchronize the node labels/names of all clonotypes within all samples of two AntibodyForests objects.}
\usage{
Af_sync_nodes(reference, subject)
}
\arguments{
\item{reference}{AntibodyForests object - AntibodyForests object as obtained from the 'Af_build()' function in Platypus. This object will be used as a reference.}

\item{subject}{AntibodyForests object - AntibodyForests object as obtained from the 'Af_build()' function in Platypus. For each clonotype, the names of the nodes will be synced with the names of the nodes in the reference AntibodyForests object, by matching the barcodes.}
}
\value{
Returns the subject AntibdoyForests object in which all nodes of each clonotypes within all samples are renamed.
}
\description{
The nodes of each clonotype within each sample of the subject AntibodyForests object will be named according to the names of the nodes of the clonotypes within the samples of the reference AntibodyForests object. The node names present in all the objects within the  Therefore, the sample IDs and clonotype IDs should be the same. Note: if a node in the reference AntibodyForests object is divided over two nodes in the subject AntibodyForests object, the nodes will get a letter as suffix (for example, 'node2' in the reference object would become 'node2A' and 'node2B' in the subject object). Note: if multiple nodes in the reference AntibodyForests object are together in one node in the subject AntibodyForests object, the number of the nodes are pasted together with a '+' (for example, 'node5' and 'node6' in the reference object would become 'node5+6' in the subject object).
}
\examples{
af_mst <- Af_sync_nodes(reference = AntibodyForests::af_default,
                     subject = AntibodyForests::af_mst)
}
