% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_compare_within_repertoires.R
\name{Af_compare_within_repertoires}
\alias{Af_compare_within_repertoires}
\title{Function to compare tree topology of B cell lineages}
\usage{
Af_compare_within_repertoires(
  input,
  min.nodes,
  distance.method,
  distance.metrics,
  clustering.method,
  visualization.methods,
  plot.label,
  text.size,
  point.size = 2,
  parallel,
  num.cores
)
}
\arguments{
\item{input}{\itemize{
\item list - An AntibodyForests-object, output from Af_build()
}}

\item{min.nodes}{\itemize{
\item integer - The minimum number of nodes in a tree to include in the comparison
}}

\item{distance.method}{\itemize{
\item string - The method to calculate distance (default ...)
'none'           : No distance metric, analyze similarity directly from distance.metrics
'euclidean'      :
'jensen-shannon' : Jensen-Shannon distance between spectral density profiles of trees.
}}

\item{distance.metrics}{\itemize{
\item string - If distance.method is "none" or "euclidean", these metrics will be used to calculate clusters and PCA/MDS dimensions and are used for plotting. (Default is mean.depth and nr.nodes)
'nr.nodes'         : The total number of nodes
'nr.cells'         : The total number of cells in this clonotype
'mean.depth'       : Mean of the number of edges connecting each node to the germline
'mean.edge.length' : Mean of the edge lengths between each node and the germline
'group.depth'      : Mean of the number of edges connecting each node per group (node.features of the AntibodyForests-object) to the germline. (default FALSE)
'sackin.index'     : Sum of the number of nodes between each terminal node and the germline, normalized for the number of terminal nodes.
'spectral.density' : Metrics of the spectral density profiles (calculated with package RPANDA)
\itemize{
\item peakedness            : Tree balance
\item asymmetry             : Shallow or deep branching events
\item principal eigenvalue  : Phylogenetic diversity
\item modalities            : The number of different structures within the tree
}
}}

\item{clustering.method}{\itemize{
\item string - Method to cluster trees (default none)
'none'           : No clustering
'mediods'        : Clustering based on the k-mediods method. The number of clusters is estimated based on the optimum average silhouette.
}}

\item{visualization.methods}{\itemize{
\item string - The methods to analyze similarity (default PCA)
'PCA'            : Scatterplot of the first two principal components. This is usefull when distance.method is "none".
'MDS'            : Scatterplot of the first two dimensions using multidimensional scaling. Usefull for all distance methods
'heatmap'        : A (clustered) heatmap of the distance between clonotypes. If distance.method is "none", euclidean distance will be calculated.
}}

\item{plot.label}{\itemize{
\item boolean - Label clonotypes in the PCA/MDS plot (default FALSE)
}}

\item{text.size}{\itemize{
\item integer - Size of the text in the plots (default 12)
}}

\item{point.size}{\itemize{
\item integer - Size of the points in the plots (default 2)
}}

\item{parallel}{If TRUE, the metric calculations are parallelized (default FALSE)}

\item{num.cores}{Number of cores to be used when parallel = TRUE (Defaults to all available cores - 1)}
}
\value{
\itemize{
\item list - Returns a distance matrix, clustering, and various plots based on visualization.methods
}
}
\description{
Function to compare trees of clonotypes.
}
\examples{
compare_repertoire <- Af_compare_within_repertoires(input = AntibodyForests::small_af,
                                     min.nodes = 8,
                                     distance.method = "euclidean",
                                     distance.metrics = c("mean.depth", "sackin.index"),
                                     clustering.method = "mediods",
                                     visualization.methods = "PCA")
#Plot the PCA clusters
compare_repertoire$plots$PCA_clusters
}
