% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{names.AmigaBasic}
\alias{names.AmigaBasic}
\alias{names<-.AmigaBasic}
\title{Extract or replace variable and label names from Amiga Basic scripts}
\usage{
\method{names}{AmigaBasic}(x)

\method{names}{AmigaBasic}(x) <- value
}
\arguments{
\item{x}{An \code{\link[=AmigaBasic]{AmigaBasic()}}-class object for which to obtain or change variable and/or label names}

\item{value}{A (\code{vector} of) \code{character} string of desired replacement variable/label names.}
}
\value{
A \code{vector} of \code{character} strings with label and variable names in the basic script.
In case of the replacement method a \code{\link[=AmigaBasic]{AmigaBasic()}}-class with replaced names is returned.
}
\description{
In the binary Amiga Basic files, names for labels and variables
in the code are stored at the end of the file. In the encoded
there is only a pointer to the index of the name in that list. Use
this function to list, select or replace names included in the code
}
\details{
Make sure that variable and label names are valid for the basic script (see \link{check.names.AmigaBasic}).
}
\examples{
## Let's create some Basic code with labels and variables:
bas <- as.AmigaBasic(c(
  "REM - This will loop forever...",
  "my.label:",
  "  my.variable\% = 0",
  "  WHILE my.variable\% < 10",
  "    my.variable\% = my.variable\% + 1",
  "  WEND",
  "  GOTO my.label"
))

## list the names in the script above:
names(bas)

## change the first name:
names(bas)[1] <- "better.label"
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic}},
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{write.AmigaBasic}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
