% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.R
\name{Extract}
\alias{Extract}
\title{Extracting specific columns from a data\cr}
\usage{
Extract(X, varind, interaction.ind = NULL)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} by \code{nmain.p}. Note that the two-way interaction effects should not
be included in \code{X} because this function automatically generates the
corresponding two-way interaction effects if needed.}

\item{varind}{A numeric vector of class \code{c()} that specifies the indices
of variables to be extracted from \code{X}. Duplicated values are not allowed.
See Example section for details.}

\item{interaction.ind}{A two-column numeric matrix containing all possible
two-way interaction effects. It must be generated outside of this function using
\code{t(utils::combn())}. See Example section for details.}
}
\value{
A numeric matrix is returned.
}
\description{
This function extracts specific columns from \code{X} based on \code{varind}.
It provides an efficient procedure for conducting ABC evaluation,
especially when working with high-dimensional data.
}
\details{
Please be aware that this function automatically renames column names
into a designated format (e.g., X.1, X.2 for main effects, and X.1X.2 for
interaction effect, etc), regardless of the original column names in \code{X}.

Under no heredity condition, this function can be applied in the context of
interaction only linear regression models. See Example section for details.
}
\examples{
# Extract main effect X1 and X2 from X1,...X4
set.seed(0)
X1 <- matrix(rnorm(20), ncol = 4)
y1 <- X1[, 2] + rnorm(5)
interaction.ind <- t(combn(4,2))

# Extract main effect X1 and interaction effect X1X2 from X1,..X4
Extract(X1, varind = c(1,5), interaction.ind)

# Extract interaction effect X1X2 from X1,...X4
Extract(X1, varind = 5, interaction.ind)

# Extract using duplicated values in varind.
try(Extract(X1, varind = c(1,1), interaction.ind)) # this will not run
}
\seealso{
\code{\link{ABC}}, \code{\link{initial}}.
}
