% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{KPI_table.as_data}
\alias{KPI_table.as_data}
\title{KPI table}
\usage{
\method{KPI_table}{as_data}(data_object, predictions = NULL, test = TRUE, ...)
}
\arguments{
\item{data_object}{an object of class \code{as_data}.}

\item{predictions}{a data frame with the predicted KPI for each algorithm (columns) and for each instance (rows). If NULL, the table won't include a ML column.}

\item{test}{flag that indicates whether the function should use test data or training data.}

\item{...}{other parameters.}
}
\value{
A table with the statistics of the pace.
}
\description{
Function that generates a table with the values of the KPI.
}
\examples{
data(branchingsmall)
data_object <- partition_and_normalize(branchingsmall$x, branchingsmall$y, test_size = 0.3,
family_column = 1, split_by_family = TRUE)
training <- AStrain(data_object, method = "glm")
predictions <- ASpredict(training, newdata = data_object$x.test)
KPI_table(data_object, predictions = predictions)
}
