% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{stan}
\alias{stan}
\title{stan: Standardize Training, Validation, and Test Datasets}
\usage{
stan(train, validation = NULL, test = NULL)
}
\arguments{
\item{train}{A list containing the training set. The list must have a component `X` for predictors.}

\item{validation}{A list containing the validation set. The list must have a component `X` for predictors. If `NULL`, the validation set is not standardized. Default is `NULL`.}

\item{test}{A list containing the test set. The list must have a component `X` for predictors. If `NULL`, the test set is not standardized. Default is `NULL`.}
}
\value{
A list with the following components:
\item{train}{The standardized training set, with predictors centered and scaled.}
\item{validation}{The standardized validation set (if provided), standardized using the training set's mean and standard deviation.}
\item{test}{The standardized test set (if provided), standardized using the training set's mean and standard deviation.}
}
\description{
This function standardizes the training, validation, and test datasets by centering and scaling 
them using the mean and standard deviation from the training set. It ensures that the validation 
and test sets are transformed using the same parameters derived from the training data.
}
\examples{
# Example usage
train_data <- list(X = matrix(rnorm(100), ncol=10))
validation_data <- list(X = matrix(rnorm(50), ncol=10))
test_data <- list(X = matrix(rnorm(50), ncol=10))

standardized <- stan(train = train_data, validation = validation_data, test = test_data)

}
