% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_other_language.R
\name{calc_other_language}
\alias{calc_other_language}
\title{Calculate Whether Participant Speaks a Language Other Than English at Home}
\usage{
calc_other_language(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer`.}
}
\value{
A data frame with two columns: `person_id` and `other_language`, where `other_language` contains the values
'Yes', 'No', or 'PMI: Prefer Not To Answer'. Participants without data or who skipped the question will have NA values.
}
\description{
This function creates a nominal categorical variable with values 'Yes', 'No', or 'PMI: Prefer Not To Answer',
indicating whether the participant speaks a language other than English at home.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5),
  question_concept_id = rep(40192526, 5),
  answer = c("Yes", "No", "Yes", "Prefer Not To Answer", "Skip")
)

# Compute whether participants speak a language other than English at home
other_language_scores <- calc_other_language(survey_df)
head(other_language_scores)

}
