% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hcd_ever.R
\name{calc_hcd_ever}
\alias{calc_hcd_ever}
\title{Calculate Ever Experienced Health Care Discrimination}
\usage{
calc_hcd_ever(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `hcd_ever`, where `hcd_ever` is TRUE if the participant
endorsed any form of discrimination in health care and FALSE otherwise. Participants who did not respond
to all 7 items will have an NA value for `hcd_ever`.
}
\description{
This function creates a binary categorical variable (TRUE/FALSE) indicating whether a participant has ever endorsed
perceived discrimination in health care based on responses to seven specific survey items.
TRUE indicates that the participant has experienced at least one instance of perceived discrimination.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 7),
  question_concept_id = rep(c(40192383, 40192394, 40192423, 40192425,
                              40192497, 40192503, 40192505), times = 3),
  answer_concept_id = sample(c(40192465, 40192481, 40192429, 40192382, 40192515),
                             21, replace = TRUE)
)

# Compute whether participants have ever experienced health care discrimination
hcd_ever_scores <- calc_hcd_ever(survey_df)
head(hcd_ever_scores)

}
