% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_density.R
\name{calc_density}
\alias{calc_density}
\title{Calculate Residential Density}
\usage{
calc_density(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `density`, where `density`
is either "High" or "Low" based on the housing type in the neighborhood. Participants with
non-answers will have an NA value for `density`.
}
\description{
This function creates a binary categorical variable representing residential density
based on survey responses. 'Low' denotes low residential density (detached single-family housing),
while 'High' denotes high residential density.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5),
  question_concept_id = c(40192458, 40192458, 40192458, 40192458, 40192458),
  answer_concept_id = c(40192407, 40192472, 40192418, 40192433, 40192409)
)

# Compute residential density categories
density_scores <- calc_density(survey_df)
head(density_scores)

}
