% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-emFrequencies.R
\name{emFrequencies}
\alias{emFrequencies}
\title{emFrequencies: simple effect analysis of frequency data.}
\usage{
emFrequencies(w, formula)
}
\arguments{
\item{w}{An ANOFA object obtained from \code{anofa()};}

\item{formula}{A formula which indicates what simple effect to analyze.
only one simple effect formula at a time can be analyzed. The formula
is given using a vertical bar, e.g., " ~ factorA | factorB " to obtain
the effect of Factor A within every level of the Factor B.}
}
\value{
a model fit of the simple effect.
}
\description{
The function \code{emFrequencies()} performs a simple effect analyses
of frequencies after an omnibus analysis has been obtained with \code{anofa()}
according to the ANOFA framework. See \insertCite{lc23b;textual}{ANOFA} for more.
}
\details{
emFrequencies computes expected marginal frequencies and
analyze the hypothesis of equal frequencies.
The sum of the Gs of the simple effects are equal to the
interaction and main effect Gs, as this is an additive decomposition
of the effects.
}
\examples{
# Basic example using a two-factors design with the data in compiled format. 
# Ficticious data present frequency of observation classified according
# to Intensity (three levels) and Pitch (two levels) for 6 possible cells.
minimalExample

# performs the omnibus analysis first (mandatory):
w <- anofa(Frequency ~ Intensity * Pitch, minimalExample) 
summary(w)

# execute the simple effect of Pitch for every levels of Intensity
e <- emFrequencies(w, ~ Pitch | Intensity)
summary(e)

# As a check, you can verify that the Gs are decomposed additively
sum(e$results[,1])
w$results[3,1]+w$results[4,1] 

# Real-data example using a two-factor design with the data in compiled format:
LandisBarrettGalvin2013

w <- anofa( obsfreq ~ provider * program, LandisBarrettGalvin2013)
anofaPlot(w)
summary(w)

# there is an interaction, so look for simple effects
e <- emFrequencies(w, ~ program | provider )
summary(e)

# Example from Gillet1993 : 3 factors for appletrees 
Gillet1993

w <- anofa( Freq ~ species * location * florished, Gillet1993)
e <- emFrequencies(w, ~ florished | location )

# Again, as a check, you can verify that the Gs are decomposed additively
w$results[4,1]+w$results[7,1] # B + B:C
sum(e$results[,1])

# You can ask easier outputs with
summarize(w) # or summary(w) for the ANOFA table only
explain(w)   # human-readable ouptut ((pending))


}
\references{
\insertAllCited{}
}
