% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindClustersManual.R
\name{FindClustersManual}
\alias{FindClustersManual}
\title{User-interactive routine to find clusters}
\usage{
FindClustersManual(distm, f, delta)
}
\arguments{
\item{distm}{distance matrix.}

\item{f}{vector of local densities f(x). Same length of the number of observations.}

\item{delta}{vector of distances to the closest high ground delta(x). Same length of the number of observations.}
}
\value{
a list of the following items:
\itemize{
\item{clusters}{ Cluster assignments. A vector of the same length as the number of observations.}
\item{centers:}{ Indices of the clustering centers.}
\item{silhouette:}{ Silhouette score from the final clustering result.}
\item{nclust:}{ Number of clusters.}
}
}
\description{
Plot the f vs. delta plot, then wait for the user to select centers of clusters by left clicking the points. In general points with both large f and large delta are good candidates of cluster centroids. Selected centers are highlighted. Press ESC to end the selection.
}
\examples{
data(clust3)
distm <- FindDistm(clust3, normalize = TRUE)
\dontrun{
fd <- FindFD(distm, 2, "mnorm")
ans <- FindClustersManual(distm, fd$f, fd$delta)
names(ans)
ans$centers
}
}

