library("data.table")
library("wyz.code.offensiveProgramming")
library("wyz.code.rdoc")

gc <- GenerationContext('inst/man-samples', overwrite_b_1 = TRUE,
                        verbosity_b_1 = FALSE, useMarkers_b_1 = FALSE)

pc <- ProcessingContext(
  extraneous_l = list(
    description = "Data set to be used as example for demo purpose.",
    source = 'Data set generated by NEONIRA',
    concept = 'documentation generation'
  )
)

target_package_name <- 'wyz.code.rdoc'

# 1. file dummy.R
ic <- InputContext(dummy,
                   packageName_s_1 = target_package_name,
                   dataFilename_s_1 = 'dummy.R')

r1 <- produceManualPage(ic, pc, gc)

# 2. file family.csv
ic <- InputContext(family,
                   packageName_s_1 = target_package_name,
                   dataFilename_s_1 = 'family.csv')
r2 <- produceManualPage(ic, pc, gc)
