/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.Option;
import com.github.javacliparser.StringUtils;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<Option> optionList = new LinkedList<Option>();

    public void addOption(Option opt) {
        if (this.getOption(opt.getName()) != null) {
            throw new IllegalArgumentException("Duplicate option name: " + opt.getName());
        }
        if (this.getOption(opt.getCLIChar()) != null) {
            throw new IllegalArgumentException("Duplicate option command line character: " + opt.getCLIChar());
        }
        this.optionList.add(opt);
    }

    public int numOptions() {
        return this.optionList.size();
    }

    public Option getOption(String optName) {
        for (Option option : this.optionList) {
            if (!optName.equals(option.getName())) continue;
            return option;
        }
        return null;
    }

    public Option getOption(char cliChar) {
        for (Option option : this.optionList) {
            if (option.getCLIChar() != cliChar) continue;
            return option;
        }
        return null;
    }

    public Option[] getOptionArray() {
        return this.optionList.toArray(new Option[this.optionList.size()]);
    }

    public void removeOption(String optName) {
        this.removeOption(this.getOption(optName));
    }

    public void removeOption(Option opt) {
        this.optionList.remove(opt);
    }

    public void removeAllOptions() {
        this.optionList = new LinkedList<Option>();
    }

    public void resetToDefaults() {
        for (Option option : this.optionList) {
            option.resetToDefault();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setViaCLIString(String cliString) {
        cliString = cliString.trim();
        while (cliString.length() > 0) {
            Option opt;
            if (!cliString.startsWith("-")) throw new IllegalArgumentException("Expecting option, found: '" + cliString + "'.");
            boolean flagClusterFound = false;
            String optionString = null;
            int nextSpaceIndex = cliString.indexOf(32, 1);
            if (nextSpaceIndex > 0) {
                optionString = cliString.substring(1, nextSpaceIndex);
            } else {
                optionString = cliString.substring(1, cliString.length());
                nextSpaceIndex = cliString.length() - 1;
            }
            if (optionString.length() == 1) {
                opt = this.getOption(optionString.charAt(0));
            } else {
                opt = this.getOption(optionString);
                if (opt == null) {
                    int i;
                    flagClusterFound = true;
                    for (i = 0; i < optionString.length(); ++i) {
                        opt = this.getOption(optionString.charAt(i));
                        if (opt instanceof FlagOption) continue;
                        flagClusterFound = false;
                        opt = null;
                        break;
                    }
                    if (flagClusterFound) {
                        for (i = 0; i < optionString.length(); ++i) {
                            opt = this.getOption(optionString.charAt(i));
                            opt.setValueViaCLIString("");
                        }
                        cliString = cliString.substring(nextSpaceIndex + 1, cliString.length());
                    }
                }
            }
            if (!flagClusterFound) {
                if (opt == null) throw new IllegalArgumentException("Unknown option: -" + optionString);
                String parameters = cliString.substring(nextSpaceIndex + 1, cliString.length());
                if (opt instanceof FlagOption) {
                    opt.setValueViaCLIString("");
                    cliString = parameters;
                } else {
                    String[] paramSplit = Options.splitParameterFromRemainingOptions(parameters);
                    opt.setValueViaCLIString(paramSplit[0]);
                    cliString = paramSplit[1];
                }
            }
            cliString = cliString.trim();
        }
    }

    public String getAsCLIString() {
        StringBuilder commandLine = new StringBuilder();
        for (Option option : this.optionList) {
            String value = option.getValueAsCLIString();
            if (value == null || value.equals(option.getDefaultCLIString())) continue;
            if (commandLine.length() > 0) {
                commandLine.append(" ");
            }
            commandLine.append("-" + option.getCLIChar());
            if (value.length() <= 0) continue;
            if (value.indexOf(32) < 0) {
                commandLine.append(" " + value);
                continue;
            }
            commandLine.append(" (" + value + ")");
        }
        return commandLine.toString();
    }

    public String getHelpString() {
        StringBuilder sb = new StringBuilder();
        this.getHelp(sb, 0);
        return sb.toString();
    }

    public void getHelp(StringBuilder sb, int indent) {
        if (this.optionList.size() > 0) {
            for (Option option : this.optionList) {
                StringUtils.appendIndent(sb, indent);
                sb.append('-');
                sb.append(option.getCLIChar());
                sb.append(' ');
                sb.append(option.getName());
                String defaultString = option.getDefaultCLIString();
                if (defaultString != null && defaultString.length() > 0) {
                    sb.append(" (default: ");
                    sb.append(defaultString);
                    sb.append(')');
                }
                StringUtils.appendNewline(sb);
                StringUtils.appendIndent(sb, indent);
                sb.append(option.getPurpose());
                StringUtils.appendNewline(sb);
            }
        } else {
            StringUtils.appendIndented(sb, indent, "No options.");
        }
    }

    protected static String[] splitParameterFromRemainingOptions(String cliString) {
        String[] paramSplit = new String[2];
        if ((cliString = cliString.trim()).startsWith("\"") || cliString.startsWith("'")) {
            int endQuoteIndex = cliString.indexOf(cliString.charAt(0), 1);
            if (endQuoteIndex < 0) {
                throw new IllegalArgumentException("Quotes not terminated correctly.");
            }
            paramSplit[0] = cliString.substring(1, endQuoteIndex);
            paramSplit[1] = cliString.substring(endQuoteIndex + 1, cliString.length());
        } else if (cliString.startsWith("(")) {
            int bracketsOpen = 1;
            int currPos = 1;
            int nextCloseIndex = cliString.indexOf(")", currPos);
            int nextOpenIndex = cliString.indexOf("(", currPos);
            while (bracketsOpen != 0) {
                if (nextCloseIndex < 0) {
                    throw new IllegalArgumentException("Brackets do not match.");
                }
                if (nextOpenIndex < 0 || nextCloseIndex < nextOpenIndex) {
                    --bracketsOpen;
                    currPos = nextCloseIndex + 1;
                    nextCloseIndex = cliString.indexOf(")", currPos);
                    continue;
                }
                ++bracketsOpen;
                currPos = nextOpenIndex + 1;
                nextOpenIndex = cliString.indexOf("(", currPos);
            }
            paramSplit[0] = cliString.substring(1, currPos - 1);
            paramSplit[1] = cliString.substring(currPos, cliString.length());
        } else {
            int firstSpaceIndex = cliString.indexOf(" ", 0);
            if (firstSpaceIndex >= 0) {
                paramSplit[0] = cliString.substring(0, firstSpaceIndex);
                paramSplit[1] = cliString.substring(firstSpaceIndex + 1, cliString.length());
            } else {
                paramSplit[0] = cliString;
                paramSplit[1] = "";
            }
        }
        return paramSplit;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

