/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets;

import java.util.Iterator;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataView;

public class YearIterator
implements Iterator<TsDataView> {
    private TsDataView m_cur;
    private final TsDataView m_data;

    public static YearIterator fullYears(TsData series) {
        TsDomain domain = series.getDomain();
        int ifreq = domain.getAnnualFrequency();
        int nbeg = series.getStart().annualPosition();
        int nend = series.getEnd().annualPosition();
        domain = domain.drop(nbeg == 0 ? 0 : ifreq - nbeg, nend);
        return new YearIterator(series, domain);
    }

    public YearIterator(TsData series) {
        if (!series.isEmpty()) {
            this.m_data = TsDataView.all(series);
            this.initialize();
        } else {
            this.m_data = null;
        }
    }

    public YearIterator(TsData series, TsDomain domain) {
        this.m_data = TsDataView.select(series, domain);
        this.initialize();
    }

    public YearIterator(TsData series, TimeSelector selector) {
        this.m_data = TsDataView.select(series, selector);
        this.initialize();
    }

    @Override
    public boolean hasNext() {
        if (this.m_data == null) {
            return false;
        }
        return this.m_cur != null;
    }

    private void initialize() {
        int ifreq = this.m_data.getStart().annualFrequency();
        int beg = this.m_data.getStart().annualPosition();
        int end = ifreq;
        int n = this.m_data.getData().length();
        if (end > n) {
            end = n;
        }
        this.m_cur = new TsDataView(this.m_data.getStart(), this.m_data.getData().range(0, end - beg), 1);
    }

    @Override
    public TsDataView next() {
        TsDataView view = this.m_cur;
        if (view == null) {
            return null;
        }
        TsPeriod start = this.m_data.getStart();
        TsPeriod cstart = view.getStart();
        int n = this.m_data.getData().length();
        int ifreq = this.m_data.getStart().annualFrequency();
        int cn = view.getData().length();
        int cbeg = start.until(cstart) + cn;
        if (cbeg >= n) {
            this.m_cur = null;
        } else {
            cstart = start.plus((long)cbeg);
            int cend = cbeg + ifreq;
            if (cend > n) {
                cend = n;
            }
            this.m_cur = new TsDataView(cstart, this.m_data.getData().range(cbeg, cend), 1);
        }
        return view;
    }

    public void reset() {
        this.initialize();
    }
}

