/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.ForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.IRationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;

public final class RationalForeFilter
implements IRationalFilter {
    public static final RationalForeFilter ZERO = new RationalForeFilter();
    private final RationalFunction rationalFunction;
    private final int fshift;

    public RationalForeFilter() {
        this.rationalFunction = RationalFunction.zero();
        this.fshift = 0;
    }

    public RationalForeFilter(ForeFilter num, ForeFilter denom, int fshift) {
        this.rationalFunction = RationalFunction.of(num.getPolynomial(), denom.getPolynomial());
        this.fshift = fshift;
    }

    RationalForeFilter(RationalFunction rfe, int fshift) {
        this.rationalFunction = rfe;
        this.fshift = fshift;
    }

    public RationalForeFilter drop(int n) {
        RationalFunction rfe = this.rationalFunction.drop(n);
        return new RationalForeFilter(rfe, this.fshift + n);
    }

    @Override
    public Complex frequencyResponse(double freq) {
        Polynomial pn = this.rationalFunction.getNumerator();
        Polynomial pd = this.rationalFunction.getDenominator();
        Complex n = FilterUtility.frequencyResponse(i -> pn.get(i - this.fshift), this.fshift, this.fshift + pn.degree(), freq);
        Complex d = FilterUtility.frequencyResponse(i -> pd.get(i), 0, this.rationalFunction.getDenominator().degree(), freq);
        return n.div(d);
    }

    @Override
    public ForeFilter getDenominator() {
        Polynomial p = this.rationalFunction.getDenominator();
        return new ForeFilter(p);
    }

    public int getLBound() {
        return 0;
    }

    public RationalBackFilter getMirror() {
        return new RationalBackFilter(this.rationalFunction, this.fshift);
    }

    @Override
    public ForeFilter getNumerator() {
        Polynomial p = this.rationalFunction.getNumerator();
        return new ForeFilter(p);
    }

    public RationalFunction getRationalFunction() {
        return this.rationalFunction;
    }

    public int getUBound() {
        if (this.rationalFunction.isFinite()) {
            return this.rationalFunction.getNumerator().degree();
        }
        return Integer.MAX_VALUE;
    }

    public double weight(int pos) {
        return this.rationalFunction.get(pos);
    }

    public double[] getWeights(int n) {
        return this.rationalFunction.coefficients(n);
    }

    @Override
    public boolean hasLowerBound() {
        return true;
    }

    @Override
    public boolean hasUpperBound() {
        return this.rationalFunction.isFinite();
    }

    public void prepare(int n) {
        this.rationalFunction.prepare(n);
    }

    public RationalForeFilter times(RationalForeFilter r) {
        Polynomial ln = this.rationalFunction.getNumerator();
        Polynomial rn = r.rationalFunction.getNumerator();
        Polynomial ld = this.rationalFunction.getDenominator();
        Polynomial.SimplifyingTool psmp = new Polynomial.SimplifyingTool();
        Polynomial rd = r.rationalFunction.getDenominator();
        if (psmp.simplify(ln, rd)) {
            ln = (Polynomial)psmp.getLeft();
            rd = (Polynomial)psmp.getRight();
        }
        if (psmp.simplify(rn, ld)) {
            rn = (Polynomial)psmp.getLeft();
            ld = (Polynomial)psmp.getRight();
        }
        Polynomial n = ln.times(rn);
        Polynomial d = ld.times(rd);
        double d0 = d.get(0);
        if (d0 != 1.0) {
            n = n.divide(d0);
            d = d.divide(d0);
        }
        RationalFunction rfe = RationalFunction.of(n, d);
        return new RationalForeFilter(rfe, this.fshift + r.fshift);
    }

    @Override
    public RationalBackFilter getRationalBackFilter() {
        return RationalBackFilter.ZERO;
    }

    @Override
    public RationalForeFilter getRationalForeFilter() {
        return this;
    }
}

