## ----setup, include=FALSE-----------------------------------------------------
library(here)
library(devtools)
knitr::opts_chunk$set(echo = TRUE)
devtools::load_all(here())

## -----------------------------------------------------------------------------
dataA <- financial()
dataB <- social()

## -----------------------------------------------------------------------------
fn <- dataA$poor_liq ~ Dcollege+Totalincome+Dunemp

## -----------------------------------------------------------------------------
q <- c(0.2,0.8) 
v <- matrix(c(1,0,-1),nrow=1)

## ----ei_gce-------------------------------------------------------------------
result <- ei_gce(fn,dataA,dataB,q=q,weights = "w",v=v)
result

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(dplyr))
summary(result)

## ----echo=TRUE----------------------------------------------------------------
plot(x=result,dataB$reg)

## -----------------------------------------------------------------------------
result2 <- ei_gce(fn,dataA,dataB,weights= "w")
result2

## -----------------------------------------------------------------------------
result3 <- ei_gme (fn,dataA,dataB,weights="w")

## -----------------------------------------------------------------------------
result3

## -----------------------------------------------------------------------------
summary(object=result3)


## ----echo=TRUE----------------------------------------------------------------
plot(x=result3, reg=dataB$reg)   

