/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.ISetDelta;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.procedure.IntProcedure;

public class SetDeltaMonitor
extends TimeStampedObject
implements ISetDeltaMonitor {
    private final ISetDelta delta;
    private final int[] first;
    private final int[] last;
    private final ICause propagator;

    public SetDeltaMonitor(ISetDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = new int[2];
        this.last = new int[2];
        this.propagator = propagator;
    }

    @Override
    public void startMonitoring() {
        this.delta.lazyClear();
        this.resetStamp();
        for (int i = 0; i < 2; ++i) {
            this.first[i] = this.last[i] = this.delta.getSize(i);
        }
    }

    private void freeze() {
        int i;
        if (this.getTimeStamp() == -1) {
            throw new SolverException("Delta Monitor created in this is not activated. This should be the last instruction of p.propagate(int) by calling `monitor.startMonitoring()`");
        }
        if (this.needReset()) {
            this.delta.lazyClear();
            for (i = 0; i < 2; ++i) {
                this.first[i] = 0;
            }
            this.resetStamp();
        }
        if (this.getTimeStamp() != ((TimeStampedObject)((Object)this.delta)).getTimeStamp()) {
            throw new SolverException("Delta and monitor are not synchronized. \ndeltamonitor.freeze() is called but no value has been removed since the last call.");
        }
        for (i = 0; i < 2; ++i) {
            this.last[i] = this.delta.getSize(i);
        }
    }

    @Override
    public void forEach(IntProcedure proc, SetEventType evt) throws ContradictionException {
        int x;
        this.freeze();
        if (evt == SetEventType.ADD_TO_KER) {
            x = 0;
        } else if (evt == SetEventType.REMOVE_FROM_ENVELOPE) {
            x = 1;
        } else {
            throw new UnsupportedOperationException("The event in parameter should be ADD_TO_KER or REMOVE_FROM_ENVELOPE");
        }
        while (this.first[x] < this.last[x]) {
            if (this.delta.getCause(this.first[x], x) != this.propagator) {
                proc.execute(this.delta.get(this.first[x], x));
            }
            int n = x;
            this.first[n] = this.first[n] + 1;
        }
    }
}

