/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.UpdatablePropagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

@Explained
public class PropNotMember
extends Propagator<IntVar>
implements UpdatablePropagator<IntIterableRangeSet> {
    private final IntIterableRangeSet range;

    public PropNotMember(IntVar var, IntIterableRangeSet range, boolean isObjectiveFunction) {
        super((Variable[])new IntVar[]{var}, (Priority)PropagatorPriority.UNARY, false, !isObjectiveFunction);
        this.range = range.duplicate();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropNotMember.enforce(((IntVar[])this.vars)[0], this.range, this)) {
            this.setPassive();
        }
    }

    private static boolean enforce(IntVar var, IntIterableRangeSet fset, Propagator<IntVar> prop) throws ContradictionException {
        boolean rem = false;
        if (prop.lcg()) {
            ISetIterator iSetIterator = fset.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                rem |= var.removeValue(i, prop, Reason.undef());
            }
        } else {
            rem = var.removeValues(fset, prop, Reason.undef());
        }
        return rem && (var.hasEnumeratedDomain() || IntIterableSetUtils.notIncludedIn(var, fset));
    }

    @Override
    public ESat isEntailed() {
        if (IntIterableSetUtils.includedIn(((IntVar[])this.vars)[0], this.range)) {
            return ESat.FALSE;
        }
        if (this.range.intersect(((IntVar[])this.vars)[0])) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " \u2209 " + this.range;
    }

    @Override
    public void update(IntIterableRangeSet values, boolean thenForcePropagate) {
        this.range.clear();
        this.range.addAll(values);
        if (thenForcePropagate) {
            this.forcePropagationOnBacktrack();
        }
    }

    @Override
    public IntIterableRangeSet getUpdatedValue() {
        return this.range.duplicate();
    }
}

