## -----------------------------------------------------------------------------
# Load the pwlapprox2d package
library(pwlapprox2d)

# Run optimization (example: Sigmoid)
res <- optimize_main(
  choice = 1,
  accuracy = 0.0274,
  init_points = 200,
  max_iter = 20,
  verbose = FALSE
)

# Extract breakpoint coordinates
bp <- res$breakpoints_coords

# Print table of x,y coordinates
cat("x,y\n")
for(i in 1:nrow(bp)) {
  cat(paste(bp[i, "x"], bp[i, "y"], sep = ","), "\n")
}

