## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "##",
  message = TRUE,
  warning = FALSE
  )
options(knitr.kable.NA = ".")

## ----eval = FALSE-------------------------------------------------------------
# install.packages("mtrank")

## ----eval = FALSE-------------------------------------------------------------
# remotes::install_github("TEvrenoglou/mtrank")

## -----------------------------------------------------------------------------
library("mtrank")

## -----------------------------------------------------------------------------
data("antidepressants")
#
pw <- pairwise(studlab = studyid, treat = drug_name,
  n = ntotal, event = responders,
  data = antidepressants, sm = "OR")
#
net <- netmeta(pw, reference.group = "tra")

## -----------------------------------------------------------------------------
ranks <- tcc(net, swd = 1.25, small.values = "undesirable")

## ----eval = FALSE-------------------------------------------------------------
# ranks$preferences

## -----------------------------------------------------------------------------
c(ranks$swd.below.null, ranks$swd.above.null)

## ----eval = FALSE-------------------------------------------------------------
# ranks <- tcc(net, swd.below = 0.80, swd.above = 1.25,
#   small.values = "undesirable")

## ----eval = FALSE-------------------------------------------------------------
# forest(ranks, xlim = c(-1, 2),
#   reference.group = "bupropion", baseline.reference = FALSE,
#   label.left = "Favors other drug",
#   label.right = "Favors bupropion",
#   fill.equi = "lightblue", spacing = 1.5)

## ----echo = FALSE, out.width = "70%"------------------------------------------
forest(ranks, xlim = c(-1, 2),
  reference.group = "bupropion", baseline.reference = FALSE,
  label.left = "Favors other drug",
  label.right = "Favors bupropion",
  fill.equi = "lightblue", spacing = 1.5,
  file = "forest1.pdf")
knitr::include_graphics("forest1.pdf")

## -----------------------------------------------------------------------------
fit <- mtrank(ranks)

## -----------------------------------------------------------------------------
fit

## ----eval = FALSE-------------------------------------------------------------
# forest(fit)

## ----echo = FALSE, out.width = "70%"------------------------------------------
forest(fit, file = "forest2.pdf")
knitr::include_graphics("forest2.pdf")

## ----eval = FALSE-------------------------------------------------------------
# forest(fit, backtransf = TRUE)

## -----------------------------------------------------------------------------
# Perform a sensitivity analysis across different swd values assuming that 1.20 is the reference value
swd.vec <- seq(1.10, 1.50, by = 0.10)
swd.ref <- 1.20
# plot all the treatments in the network
linegraph(fit, swd = swd.vec, swd.ref = swd.ref)
# plot only the first six treatments in the order appearing at the 'swd.ref' value
linegraph(fit, swd = swd.vec, swd.ref = swd.ref, k = 6)
# plot in terms of ability estimates 
linegraph(fit, swd = swd.vec, swd.ref = swd.ref, type = "ability")



## -----------------------------------------------------------------------------
# Get probability fitted probabilities for comparison bupropion vs trazodone
fitted(fit, treat1 = "bupropion", treat2 = "trazodone",
  type = "all")

## -----------------------------------------------------------------------------
# Get probability that bupropion is better than other drugs
fitted(fit, treat1 = "bupr",
  treat2 = c("fluo", "paro", "sert", "traz", "venl"), type = "all")

