## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("NOT_CRAN"), "true")
)


## ----setup--------------------------------------------------------------------
# library(fwtraits)

## ----Retrieve fish species data for one species-------------------------------
# 
# migration <- fw_fetchdata(data = "Abramis brama",
#                           organismgroup = 'fi',
#                           ecoparams = 'migration')
# 
# head(migration$ecodata)

## ----Retrieve fish species data for one fish species--------------------------
# 
# #species data archived in fwtraits
# 
# data("speciesdata")
# 
# traitsout <- fw_fetchdata(data = speciesdata,
#                           organismgroup = 'fi',
#                           taxonomic_column = 'scientificName',
#                           ecoparams = c('migration', 'threat austria',
#                                         'oxygen tolerence', 'migration fibs'),
#                           taxalevel = 'species')
# 
# head(traitsout$ecodata)
# 

## ----Viszualize outputs for fish, fig.width = 8, fig.height= 6, fig.align='center'----
# 
# fw_visualize(output = traitsout)
# 

## ----Macroinvertebrates traits retrieval for one species----------------------
# 
# mmdata_traits <- fw_fetchdata(data =  "Margaritifera margaritifera",
#                               organismgroup = 'mi',
#                               ecoparams = c('stream zonation preference'),
#                               inform = TRUE)

## ----Species names in alist or vector for macroinvertebrates------------------
# 
# speciesvec <- c("Margaritifera margaritifera",
#                 "Pseudunio auricularius",
#                 "Musculium lacustre",
#                 "Musculium transversum",
#                 "Parastenocaris germanica")
# 
# multspp <- fw_fetchdata(data =  speciesvec,
#                         organismgroup = 'mi',
#                         ecoparams = c('stream zonation preference'),
#                         inform = TRUE)
# head(multspp$ecodata)
# 

## ----Species names in a dataframe not list or vector--------------------------
# 
# macrodf <- data.frame(organismgroup = rep('mi', 13),
#                       species = c("Margaritifera margaritifera",
#                                   "Pseudunio auricularius",
#                                   "Musculium lacustre",
#                                   "Musculium transversum",
#                                   "Corbicula fluminea",
#                                   "Congeria leucophaeata",
#                                   "Dreissena polymorpha",
#                                   "Dreissena rostriformis bugensis",
#                                   "Parastenocaris germaica",
#                                   "Branchiobdella balcanica",
#                                   "Branchiobdella hexadonta",
#                                   "Branchiobdella parasita",
#                                   "Branchiobdella pentadonta"))
# 
# multspp_df <- fw_fetchdata(data =  macrodf,
#                            organismgroup = 'mi',
#                            taxonomic_column = 'species',
#                            ecoparams = c("stream zonation preference", "feeding type"),
#                            inform = TRUE)
# head(multspp_df$ecodata)
# 

## ----Viszualize outputs for macroinvertebrates, fig.width = 6, fig.height= 5, fig.align='center'----
# 
# fw_visualize(output = multspp)
# 
# fw_visualize(output = multspp_df)
# 

## ----Species names in list or vector for macrophytes--------------------------
# 
# mpp <- fw_fetchdata(data = c("Amblystegium fluviatile",
#                              "Amblystegium humile",
#                              "Amblystegium riparium",
#                              "Amblystegium serpens",
#                              "Amblystegium tenax",
#                              "Amblystegium varium"),
#                     organismgroup = 'mp',
#                     ecoparams = c('zone - systema'))
# 

## ----Species names in a list or vector for phytobenthos-----------------------
# 
# pbdata <- fw_fetchdata(data = c("Gongrosira debaryana",
#                                 "Gongrosira fluminensis",
#                                 "Hydrodictyon reticulatum",
#                                 "Sphaerobotrys fluviatilis",
#                                 "Stigeoclonium farctum",
#                                 "Stigeoclonium tenue",
#                                 "Tetraspora gelatinosa",
#                                 "Thorea hispida"),
#                        organismgroup = 'pb',
#                        ecoparams = c('substrate preference'))
# head(pbdata$ecodata)
# 

## ----Species names in a list for phytobenthos and macroinvertebrates----------
# 
# mipbdata <- fw_fetchdata(data = list(mi=c("Congeria kusceri",
#                                           "Congeria leucophaeata",
#                                           "Dreissena polymorpha",
#                                           "Dreissena rostriformis bugensis"),
#                                      pb= c("Gongrosira debaryana",
#                                            "Gongrosira fluminensis",
#                                            "Hydrodictyon reticulatum",
#                                            "Sphaerobotrys fluviatilis",
#                                            "Stigeoclonium farctum",
#                                            "Stigeoclonium tenue",
#                                            "Tetraspora gelatinosa",
#                                            "Thorea hispida")),
#                          organismgroup = c('mi','pb'),
#                          ecoparams = list(mi = c('stream zonation preference'),
#                                           pb = c('substrate preference')), details = TRUE)
# 
# head(mipbdata$ecodata)
# 

## ----Species names in list or vector for phytoplankton------------------------
# 
# ppdata <- fw_fetchdata(data = c("Navicula radiosa", 'Acanthoceras zachariasii',
#                                 "Achnanthes brevipes",
#                                 "Achnanthidium catenatum",
#                                 "Actinocyclus normanii",
#                                 "Achnanthidium subatomus"),
#                        organismgroup = 'pp',
#                        ecoparams = c('stenoecy factor', 'life form'),
#                        cachefolder = 'cache',
#                        warn = TRUE,
#                        inform = TRUE)
# 
# head(ppdata$ecodata)
# 

## ----TaxaGroup and Genus taxa levels for phytoplankton------------------------
# 
# ppdata_genus <- fw_fetchdata(data = c("Navicula"),
#                        organismgroup = 'pp',
#                        ecoparams = c('stenoecy factor', 'life form'),
#                        cachefolder = 'cache',
#                        taxalevel = 'genus',
#                        inform = TRUE)
# 
# #Only Navicula genus but but multiple species
# print(unique(ppdata_genus$ecodata$Genus))
# 
# 
# ppdata_taxagroup <- fw_fetchdata(data = c("Bacillariophyceae"),
#                        organismgroup = 'pp',
#                        ecoparams = c('stenoecy factor', 'life form'),
#                        cachefolder = 'cache',
#                        taxalevel = 'taxagroup',
#                        inform = TRUE)
# 
#  #More than more 1 genus
# print(unique(ppdata_taxagroup$ecodata$Genus)[1:5])
# 

