## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  warning = FALSE
)

## -----------------------------------------------------------------------------
# read in the data
x <- c(3, 7, 11, 0, 7, 0, 4, 5, 6, 2)

# make the qqplot
qqnorm(x)
qqline(x)

## -----------------------------------------------------------------------------
n <- length(x)

# calculate the z-statistic
t_stat <- (mean(x) - 3) / (sd(x) / sqrt(n))
t_stat

## -----------------------------------------------------------------------------
library(distributions3)

T_9 <- StudentsT(df = 9)  # make a T_9 distribution
1 - cdf(T_9, 1.38) + cdf(T_9, -1.38)

## -----------------------------------------------------------------------------
1 - cdf(T_9, abs(t_stat)) + cdf(T_9, -abs(t_stat))

## -----------------------------------------------------------------------------
2 * cdf(T_9, -1.38)

## -----------------------------------------------------------------------------
1 - cdf(T_9, 1.38)

## -----------------------------------------------------------------------------
cdf(T_9, 1.38)

## -----------------------------------------------------------------------------
t.test(x, mu = 3)

## -----------------------------------------------------------------------------
t.test(x)

## -----------------------------------------------------------------------------
t.test(x, mu = 3, alternative = "greater")

## -----------------------------------------------------------------------------
t.test(x, mu = 3, alternative = "less")

