## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(csvwr)

compsci_csv <- csvwr_example("computer-scientists.csv")

cat(readLines(compsci_csv),sep="\n")

## -----------------------------------------------------------------------------
compsci_json <- csvwr_example("computer-scientists.json")

cat(readLines(compsci_json),sep="\n")

## -----------------------------------------------------------------------------
d <- read_csvw_dataframe(compsci_csv, compsci_json)

## -----------------------------------------------------------------------------
str(d)

knitr::kable(d)

## -----------------------------------------------------------------------------
csvw <- read_csvw(compsci_csv, compsci_json)

## -----------------------------------------------------------------------------
csvw$tables[[1]]$tableSchema$columns

## -----------------------------------------------------------------------------
csvw$tables[[1]]$dataframe

## -----------------------------------------------------------------------------
d <- data.frame(x=c("a","b","c"), y=1:3)
(s <- derive_table_schema(d))

## ----eval=F-------------------------------------------------------------------
#  write.csv(d, "table.csv", row.names=FALSE)

## -----------------------------------------------------------------------------
tb <- list(url="table.csv", tableSchema=s)

## -----------------------------------------------------------------------------
(m <- create_metadata(tables=list(tb)))

## -----------------------------------------------------------------------------
j <- jsonlite::toJSON(m)
jsonlite::prettify(j)

## ----eval=F-------------------------------------------------------------------
#  cat(j, file="metadata.json")

