## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(Tivy)

## -----------------------------------------------------------------------------
# # Basic distance calculation
# distances <- coast_distance(
#   lon = your_data$longitude,
#   lat = your_data$latitude,
#   distance_type = "haversine",
#   unit = "nm"
# )
# 
# # With custom coastline data
# distances <- coast_distance(
#   lon = your_data$longitude,
#   lat = your_data$latitude,
#   coastline = custom_coastline,
#   unit = "km"
# )

## -----------------------------------------------------------------------------
# # Convert DMS to decimal degrees
# decimal_coords <- dms_to_decimal(
#   coordinates = c("15°30'S", "75°45'W"),
#   hemisphere = "S",
#   correct_errors = TRUE
# )
# 
# # Handle coordinate errors automatically
# problematic_coords <- c("15°70'S", "invalid")  # Invalid minutes
# corrected <- dms_to_decimal(
#   coordinates = problematic_coords,
#   correct_errors = TRUE
# )

## -----------------------------------------------------------------------------
# # Classify points
# classification <- land_points(
#   x_point = your_data$longitude,
#   y_point = your_data$latitude,
#   parallel = TRUE,
#   cores = 2
# )

## -----------------------------------------------------------------------------
# # Load Peru coastline
# data("peru_coastline")
# 
# # Use in calculations
# distances <- coast_distance(
#   lon = c(-77.0, -76.5),
#   lat = c(-12.0, -11.5),
#   coastline = peru_coastline
# )

## -----------------------------------------------------------------------------
# # Add distance categories to your data
# enhanced_data <- add_variables(
#   data = your_data,
#   distance_type = "haversine",
#   unit = "nm"
# )
# 
# # The function adds:
# # - dc: distance to coast
# # - dc_cat: distance categories (05-15 nm, 15-30 nm, etc.)

## -----------------------------------------------------------------------------
# # Enable parallel processing
# distances <- coast_distance(
#   lon = large_dataset$longitude,
#   lat = large_dataset$latitude,
#   parallel = TRUE,
#   cores = 4
# )

## -----------------------------------------------------------------------------
# # Plot fishing zones (if you have zone data)
# plot_fishing_zones(
#   data = zone_data,
#   coastline = peru_coastline,
#   type = "static",
#   title = "Fishing Zones"
# )

