## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(rmarkdown.html_vignette.check_title = FALSE)

## ----setup--------------------------------------------------------------------
library(TensorMCMC)

## ----example, echo=TRUE, eval=TRUE--------------------------------------------
set.seed(2026)
n <- 100   # number of observations
p <- 7    # first tensor dimension
d <- 5   # second tensor dimension
pgamma <- 2 # number of scalar covariates

x <- array(rnorm(n*p*d), dim = c(n,p,d)) #Tensor predictor array

z <- matrix(rnorm(n*pgamma), n, pgamma) #Scalar covariates

y <- rnorm(n) #Response

## -----------------------------------------------------------------------------

## Fitting Tensor Regression
fit <- tensor.reg(z, x, y, nsweep = 10, rank = 2)
fit 

## Predictions

pred <- predict_tensor_reg(fit, x, z)
head(pred)

## Cross-Validation

cv <- cv.tensor.reg(x, z, y, ranks = 1:2, nsweep = 5)
cv


## ----plot-pred, fig.width=8, fig.height=6-------------------------------------

## Scatter plot of predicted vs actual
plot(y, pred, pch = 19, col = "blue",
     main = "Predicted vs Actual Response",
     xlab = "Actual y", ylab = "Predicted y")
abline(a = 0, b = 1, col = "red", lty = 2) 


## ----scatter-x1-pred, fig.width=8, fig.height=6-------------------------------

x1 <- x[,1,1]  

## Scatter plot of Predicted vs Tensor Covariate
plot(x1, pred, pch = 19, col = "purple",
     main = "Predicted vs Tensor Covariate",
     xlab = "Tensor Covariate", ylab = "Predicted y")
abline(lm(pred ~ x1), col = "green", lty = 2) 


