## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  library(macro)
#  
#  #***********************************#
#  #* Define Macro Variables
#  #***********************************#
#  `&sponsor_name` <- "Acme"
#  `&study_name` <- "ABC"
#  `&prog_name` <- "l_dm"
#  `&base_dir` <- "c:/packages/macro/tests/testthat/examples"
#  `&output_dir` <- "&base_dir/output"
#  `&data_dir` <- "&base_dir/data"
#  `&data_file` <- "dm.rda"
#  `&data_name` <- "dm"
#  `&titles` <- c("Listing 1.0", "SDTM Demographics")
#  `&footnotes` <- "'Program: &prog_name..R'"
#  `&output_type` <- "PDF"
#  `&preview` <- TRUE
#  
#  #***********************************#
#  #* Macro Source Listing Template Code
#  #***********************************#
#  msource(file.path(`&base_dir`, "templates/lst02.R"),
#          file.path(`&base_dir`, "code/l_dm2.R"),
#          debug = TRUE)
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #####################################################################
#  # Program Name: &prog_name.
#  # Study: &study_name.
#  #####################################################################
#  
#  library(reporter)
#  
#  # Output path
#  out_pth <- "&output_dir./&prog_name."
#  
#  # Get listing data
#  load("&data_dir./&data_file.")
#  
#  # Create table object
#  tbl <- create_table(`&data_name.`) |>
#    define(USUBJID, id_var = TRUE)
#  
#  #% Assign default output type
#  #%if (%symexist(output_type) == FALSE)
#  #%let output_type <- RTF
#  #%end
#  
#  # Create report object
#  rpt <- create_report(out_pth, font = "Courier", output_type = "&output_type.") |>
#    page_header("Sponsor: &sponsor_name.", "Study: &study_name.") |>
#    titles(`&titles.`) |>
#    add_content(tbl, align = "left") |>
#    footnotes(`&footnotes.`) |>
#    page_footer(Sys.time(), "CONFIDENTIAL", "Page [pg] of [tpg]")
#  
#  # Write report to file
#  #%if (&preview. == TRUE)
#  write_report(rpt, preview = 1)
#  #%else
#  write_report(rpt)
#  #%end
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #####################################################################
#  # Program Name: l_dm
#  # Study: ABC
#  #####################################################################
#  
#  library(reporter)
#  
#  # Output path
#  out_pth <- "c:/packages/macro/tests/testthat/examples/output/l_dm"
#  
#  # Get listing data
#  load("c:/packages/macro/tests/testthat/examples/data/dm.rda")
#  
#  # Create table object
#  tbl <- create_table(dm) |>
#    define(USUBJID, id_var = TRUE)
#  
#  # Create report object
#  rpt <- create_report(out_pth, font = "Courier", output_type = "PDF") |>
#    page_header("Sponsor: Acme", "Study: ABC") |>
#    titles(c('Listing 1.0', 'SDTM Demographics')) |>
#    add_content(tbl, align = "left") |>
#    footnotes('Program: l_dm.R') |>
#    page_footer(Sys.time(), "CONFIDENTIAL", "Page [pg] of [tpg]")
#  
#  # Write report to file
#  write_report(rpt, preview = 1)

