/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.randvar.PoissonGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class PoissonTIACGen
extends PoissonGen {
    private double[] pp = new double[36];
    private int[] llref = new int[]{0};
    private static double[] staticPP = new double[36];
    private static int[] staticllref = new int[]{0};

    public PoissonTIACGen(RandomStream s, double lambda) {
        super(s, null);
        this.init(lambda);
    }

    public PoissonTIACGen(RandomStream s, PoissonDist dist) {
        super(s, dist);
        this.init(dist.getLambda());
    }

    public int nextInt() {
        return PoissonTIACGen.tiac(this.stream, this.lambda, this.pp, this.llref);
    }

    public static int nextInt(RandomStream s, double lambda) {
        return PoissonTIACGen.tiac(s, lambda, staticPP, staticllref);
    }

    private void init(double lam) {
        this.setParams(lam);
        for (int i = 0; i < this.pp.length; ++i) {
            this.pp[i] = 0.0;
        }
    }

    private static int tiac(RandomStream s, double lambda, double[] pp, int[] llref) {
        double gy;
        double gx;
        double xx;
        double x;
        double v;
        double delta;
        double py;
        double px;
        double lambda_k;
        double u;
        int k;
        double a0 = -0.5000000002;
        double a1 = 0.3333333343;
        double a2 = -0.2499998565;
        double a3 = 0.1999997049;
        double a4 = -0.1666848753;
        double a5 = 0.1428833286;
        double a6 = -0.1241963125;
        double a7 = 0.1101687109;
        double a8 = -0.1142650302;
        double a9 = 0.1055093006;
        int[] fac = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880};
        if (lambda < 10.0) {
            double p;
            int m = lambda > 1.0 ? (int)lambda : 1;
            int ll = llref[0];
            double q = p = Math.exp(-lambda);
            double p0 = p;
            int k2 = 0;
            while (true) {
                double u2 = s.nextDouble();
                k2 = 0;
                if (u2 <= p0) {
                    return k2;
                }
                if (ll != 0) {
                    int i;
                    for (k2 = i = u2 > 0.458 ? Math.min(ll, m) : 1; k2 <= ll; ++k2) {
                        if (!(u2 <= pp[k2])) continue;
                        return k2;
                    }
                    if (ll == 35) continue;
                }
                for (k2 = ll + 1; k2 <= 35; ++k2) {
                    pp[k2] = q += (p *= lambda / (double)k2);
                    if (!(u2 <= q)) continue;
                    llref[0] = ll = k2;
                    return k2;
                }
                llref[0] = ll = 35;
            }
        }
        double sl = Math.sqrt(lambda);
        double d = 6.0 * lambda * lambda;
        int l = (int)(lambda - 1.1484);
        double omega = 0.3989423 / sl;
        double b1 = 0.0416666666667 / lambda;
        double b2 = 0.3 * b1 * b1;
        double c3 = 0.1428571 * b1 * b2;
        double c2 = b2 - 15.0 * c3;
        double c1 = b1 - 6.0 * b2 + 45.0 * c3;
        double c0 = 1.0 - b1 + 3.0 * b2 - 15.0 * c3;
        double c = 0.1069 / lambda;
        double t = NormalDist.inverseF(0.0, 1.0, s.nextDouble());
        double g = lambda + sl * t;
        if (g >= 0.0) {
            k = (int)g;
            if (k >= l) {
                return k;
            }
            u = s.nextDouble();
            if (d * u >= (lambda_k = lambda - (double)k) * lambda_k * lambda_k) {
                return k;
            }
            if (k < 10) {
                px = -lambda;
                py = Math.exp((double)k * Math.log(lambda)) / (double)fac[k];
            } else {
                delta = 0.083333333333 / (double)k;
                delta -= 4.8 * delta * delta * delta * (1.0 - 1.0 / (3.5 * (double)k * (double)k));
                v = lambda_k / (double)k;
                if (Math.abs(v) > 0.25) {
                    px = (double)k * Math.log(1.0 + v) - lambda_k - delta;
                } else {
                    px = (double)k * v * v;
                    px *= ((((((((0.1055093006 * v + -0.1142650302) * v + 0.1101687109) * v + -0.1241963125) * v + 0.1428833286) * v + -0.1666848753) * v + 0.1999997049) * v + -0.2499998565) * v + 0.3333333343) * v + -0.5000000002;
                    px -= delta;
                }
                py = 0.3989422804 / Math.sqrt(k);
            }
            x = (0.5 - lambda_k) / sl;
            xx = x * x;
            gx = -0.5 * xx;
            gy = omega * (((c3 * xx + c2) * xx + c1) * xx + c0);
            if (gy * (1.0 - u) <= py * Math.exp(px - gx)) {
                return k;
            }
        }
        while (true) {
            double e = -Math.log(s.nextDouble());
            u = s.nextDouble();
            int sign = (u = u + u - 1.0) < 0.0 ? -1 : 1;
            t = 1.8 + e * (double)sign;
            if (t <= -0.6744) continue;
            k = (int)(lambda + sl * t);
            lambda_k = lambda - (double)k;
            if (k < 10) {
                px = -lambda;
                py = Math.exp((double)k * Math.log(lambda)) / (double)fac[k];
            } else {
                delta = 0.083333333333 / (double)k;
                delta -= 4.8 * delta * delta * delta * (1.0 - 1.0 / (3.5 * (double)k * (double)k));
                v = lambda_k / (double)k;
                if (Math.abs(v) > 0.25) {
                    px = (double)k * Math.log(1.0 + v) - lambda_k - delta;
                } else {
                    px = (double)k * v * v;
                    px *= ((((((((0.1055093006 * v + -0.1142650302) * v + 0.1101687109) * v + -0.1241963125) * v + 0.1428833286) * v + -0.1666848753) * v + 0.1999997049) * v + -0.2499998565) * v + 0.3333333343) * v + -0.5000000002;
                    px -= delta;
                }
                py = 0.3989422804 / Math.sqrt(k);
            }
            x = (0.5 - lambda_k) / sl;
            xx = x * x;
            gx = -0.5 * xx;
            gy = omega * (((c3 * xx + c2) * xx + c1) * xx + c0);
            if (c * (double)sign * u <= py * Math.exp(px + e) - gy * Math.exp(gx + e)) break;
        }
        return k;
    }

    static {
        for (int i = 0; i < staticPP.length; ++i) {
            PoissonTIACGen.staticPP[i] = 0.0;
        }
    }
}

