## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = FALSE,
  comment = "#>"
)

## ----eval=TRUE----------------------------------------------------------------
library(paddleR)

## ----eval=FALSE---------------------------------------------------------------
# set_paddle_mode("sandbox") # Use sandbox for testing
# 
# paddle_create_customer(
#   email = "example@company.com",
#   name = "John Smith",
#   locale = "en-GB",
#   custom_data = list(industry = "SaaS", ref = "trial")
# )

## ----eval=FALSE---------------------------------------------------------------
# library(charlatan)
# 
# provider <- InternetProvider_de_DE$new()
# emails <- replicate(5, provider$company_email(), simplify = TRUE)
# 
# customers <- lapply(emails, function(email) {
#   paddle_create_customer(
#     email = email,
#     locale = "de-DE",
#     custom_data = list(industry = "SaaS", ref = "bulk")
#   )
# })

## ----eval=FALSE---------------------------------------------------------------
# # List all customers
# paddle_list_customers()

## ----eval=FALSE---------------------------------------------------------------
# # Search by email
# paddle_list_customers(email = "example@company.com")

## ----eval=FALSE---------------------------------------------------------------
# paddle_list_customers(status = "archived")

## ----eval=FALSE---------------------------------------------------------------
# paddle_update_customer(
#   customer_id = "ctm_01jxjhwrveed9zsp29qy8fmdkr",
#   name = "Johny Smith"
# )

## ----eval=FALSE---------------------------------------------------------------
# paddle_create_customer_address(
#   customer_id = "ctm_01jxjhwrveed9zsp29qy8fmdkr",
#   country_code = "US",
#   city = "New York",
#   postal_code = "10001"
# )

## ----eval=FALSE---------------------------------------------------------------
# paddle_update_customer_address(
#   customer_id = "ctm_01jxjhwrveed9zsp29qy8fmdkr",
#   address_id = "add_01jxjk35r0zskb9hvby15hrhzz",
#   city = "San Francisco"
# )

## ----eval=FALSE---------------------------------------------------------------
# paddle_create_customer_business(
#   customer_id = "ctm_01jxjhwrveed9zsp29qy8fmdkr",
#   name = "Example Company",
#   contacts = list(list(email = "ceo@ec.com", name = "Johny Smith"))
# )

## ----eval=FALSE---------------------------------------------------------------
# paddle_update_customer_business(
#   customer_id = "ctm_01jxjhwrveed9zsp29qy8fmdkr",
#   business_id = "biz_01jxjk6yqnw88jt9tepz31vnrz",
#   tax_identifier = "123456789"
# )

## ----eval=FALSE---------------------------------------------------------------
# paddle_list_credit_balances("ctm_01jxjhwrveed9zsp29qy8fmdkr")
# 
# # Filter by currency
# paddle_list_credit_balances("ctm_01jxjhwrveed9zsp29qy8fmdkr", currency_code = "USD")

## ----eval=FALSE---------------------------------------------------------------
# set_paddle_mode("live")

