/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.geometricPrim;

import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Region
implements Externalizable {
    private int oid;
    private int[] min;
    private int[] max;
    private int dim;
    private String type = "";
    public int mid = -1;
    public int dicho_ext = -1;
    public int dicho_int = -1;
    public int orientation = 0;
    public String father = "<not defined>";
    public String info = "";
    public boolean case_a_or_c = false;

    public Region(int dim, int objectId, int[] minimumBoundary, int[] maximumBoundary) {
        this.dim = dim;
        this.oid = objectId;
        this.min = new int[this.dim];
        this.max = new int[this.dim];
        this.min = minimumBoundary;
        this.max = maximumBoundary;
    }

    public Region(int dim, int objectId) {
        this.dim = dim;
        this.oid = objectId;
        this.min = new int[this.dim];
        this.max = new int[this.dim];
    }

    public Region(int dim, Obj o) {
        this.dim = dim;
        this.oid = o.getObjectId();
        this.min = new int[this.dim];
        this.max = new int[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.min[i] = o.getCoord(i).getInf();
            this.max[i] = o.getCoord(i).getSup();
        }
    }

    public Region(Region toCopy) {
        this.dim = toCopy.dim;
        this.oid = toCopy.getObjectId();
        this.min = new int[this.dim];
        this.max = new int[this.dim];
        this.mid = toCopy.mid;
        this.dicho_ext = toCopy.dicho_ext;
        this.dicho_int = toCopy.dicho_int;
        this.info = toCopy.info;
        this.father = toCopy.father;
        this.case_a_or_c = toCopy.case_a_or_c;
        this.setType(toCopy.getType());
        for (int i = 0; i < this.dim; ++i) {
            this.min[i] = toCopy.getMinimumBoundary(i);
            this.max[i] = toCopy.getMaximumBoundary(i);
        }
    }

    public Region(Point p, int objectId) {
        this.dim = p.getCoords().length;
        this.oid = objectId;
        this.min = new int[this.dim];
        this.max = new int[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.min[i] = p.getCoord(i);
            this.max[i] = p.getCoord(i);
        }
    }

    public Region(Point p) {
        this.dim = p.getCoords().length;
        this.oid = 0;
        this.min = new int[this.dim];
        this.max = new int[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.min[i] = p.getCoord(i);
            this.max[i] = p.getCoord(i);
        }
    }

    public Region(Point minimum, Point maximum) {
        this.dim = minimum.getCoords().length;
        this.oid = 0;
        this.min = new int[this.dim];
        this.max = new int[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.min[i] = minimum.getCoord(i);
            this.max[i] = maximum.getCoord(i);
        }
    }

    public void setObjectId(int objectId) {
        this.oid = objectId;
    }

    public int getObjectId() {
        return this.oid;
    }

    public void setMinimumBoundary(int index, int value) {
        this.min[index] = value;
    }

    public void setMinimumBoundary(int[] minimumBoundary) {
        this.min = (int[])minimumBoundary.clone();
    }

    public int getMinimumBoundary(int index) {
        return this.min[index];
    }

    public void setMaximumBoundary(int index, int value) {
        this.max[index] = value;
    }

    public void setMaximumBoundary(int[] maximumBoundary) {
        this.max = (int[])maximumBoundary.clone();
    }

    public int getMaximumBoundary(int index) {
        return this.max[index];
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("(");
        for (int i = 0; i < this.dim; ++i) {
            if (i != this.dim - 1) {
                res.append("[").append(this.min[i]).append(",").append(this.max[i]).append("],");
                continue;
            }
            res.append("[").append(this.min[i]).append(",").append(this.max[i]).append("]");
        }
        res.append(")");
        return res.toString();
    }

    public int volume() {
        int result = 1;
        for (int i = 0; i < this.dim; ++i) {
            result *= Math.abs(this.min[i] - this.max[i]) + 1;
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this.oid);
        out.writeObject(this.min.length);
        for (i = 0; i < this.min.length; ++i) {
            out.writeObject(this.min[i]);
        }
        out.writeObject(this.max.length);
        for (i = 0; i < this.max.length; ++i) {
            out.writeObject(this.max[i]);
        }
        out.writeObject(this.dim);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.oid = (Integer)in.readObject();
        int n = (Integer)in.readObject();
        this.min = new int[n];
        for (i = 0; i < n; ++i) {
            this.min[i] = (Integer)in.readObject();
        }
        n = (Integer)in.readObject();
        this.max = new int[n];
        for (i = 0; i < n; ++i) {
            this.max[i] = (Integer)in.readObject();
        }
        this.dim = (Integer)in.readObject();
    }

    public boolean isPoint() {
        for (int i = 0; i < this.dim; ++i) {
            if (this.min[i] == this.max[i]) continue;
            return false;
        }
        return true;
    }

    public Point point() {
        return this.pointMin();
    }

    public Point pointMin() {
        return new Point(this.min);
    }

    public Point pointMax() {
        return new Point(this.max);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getSize(int i) {
        return this.getMaximumBoundary(i) - this.getMinimumBoundary(i) + 1;
    }

    public double ratio() {
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            int s = this.getSize(i);
            if (i == 0 || (double)s < min) {
                min = s;
            }
            if (i != 0 && !((double)s > max)) continue;
            max = s;
        }
        return min / max;
    }

    public boolean included(Region box) {
        for (int i = 0; i < this.dim; ++i) {
            int a = this.min[i];
            int b = this.max[i];
            int c = box.getMinimumBoundary(i);
            int d = box.getMaximumBoundary(i);
            if (a >= c && a <= d && b >= c && b <= d) continue;
            return false;
        }
        return true;
    }
}

