## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(TFORGE)

## -----------------------------------------------------------------------------
interval_1 <- Gonjo$matrices[Gonjo$datatable$`really depth` <= 765]
interval_2 <- Gonjo$matrices[Gonjo$datatable$`really depth` <= 2154]
interval_3 <- Gonjo$matrices[Gonjo$datatable$`really depth` > 2154]
samples <- list(`1` = interval_1[1:30], `2` = interval_2[1:30], `3` = interval_3[1:30])

## -----------------------------------------------------------------------------
test_multiplicity_nonnegative(samples[["1"]], mult = c(2, 1), B = 1000)

## -----------------------------------------------------------------------------
test_multiplicity_nonnegative(samples[["2"]], mult = 3, B = 1000)

## -----------------------------------------------------------------------------
test_multiplicity_nonnegative(samples[["3"]], mult = c(1, 2), B = 1000)

## -----------------------------------------------------------------------------
test_multiplicity(samples[["1"]], mult = c(2, 1), B = 100)
test_multiplicity(samples[["2"]], mult = 3, B = 100)
test_multiplicity(samples[["3"]], mult = c(1, 2), B = 100)

## -----------------------------------------------------------------------------
test_fixedtrace(samples, B = 1000)

## -----------------------------------------------------------------------------
s1_CR <- conf_fixedtrace(samples[["1"]],
  alpha = 0.05,
  B = 100, npts = 1000, check = FALSE
)
s2_CR <- conf_fixedtrace(samples[["2"]],
  alpha = 0.05,
  B = 100, npts = 1000, check = FALSE
)
s3_CR <- conf_fixedtrace(samples[["3"]],
  alpha = 0.05,
  B = 100, npts = 1000, check = FALSE
)

