// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMULL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SMULL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_smull_8H[] = {
  0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000, 0x3f01, 0x3e04,
  0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86,
  0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54,
  0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998,
  0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0,
  0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a,
  0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc,
  0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e,
  0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000,
  0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000, 0xff82,
  0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000, 0xff81, 0xff04,
  0xfe68, 0xff01, 0xff06, 0xff82, 0x0000, 0xff80, 0xff02, 0xfc10,
  0xff67, 0xff56, 0xff83, 0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6,
  0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a,
  0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a,
  0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc,
  0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e,
  0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00,
  0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82,
  0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86,
  0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000, 0x3f01, 0x3e04, 0x3d09,
  0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe,
  0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964,
  0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8,
  0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177,
  0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa,
  0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc, 0x007d,
  0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000,
  0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000, 0xff83,
  0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000, 0xff82, 0xff06,
  0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000, 0xff81, 0xff04, 0xfc18,
  0xff01, 0xff06, 0xff82, 0x0000, 0xff80, 0xff02, 0xfc10, 0xe719,
  0xff56, 0xff83, 0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f,
  0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7,
  0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a,
  0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd,
  0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80,
  0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03,
  0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54,
  0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe,
  0x3d09, 0x3e04, 0x3f01, 0x4000, 0x3f01, 0x3e04, 0x3d09, 0x1ce4,
  0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178,
  0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0,
  0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102,
  0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac,
  0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056,
  0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc, 0x007d, 0x0000,
  0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa,
  0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000, 0xff83, 0xff54,
  0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000, 0xff82, 0xff06, 0xfd50,
  0xfe89, 0xff04, 0xff81, 0x0000, 0xff81, 0xff04, 0xfc18, 0xeede,
  0xff06, 0xff82, 0x0000, 0xff80, 0xff02, 0xfc10, 0xe719, 0xe372,
  0xff83, 0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602,
  0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac,
  0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556,
  0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00,
  0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa,
  0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998,
  0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964,
  0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178,
  0x3e04, 0x3f01, 0x4000, 0x3f01, 0x3e04, 0x3d09, 0x1ce4, 0x0a90,
  0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0,
  0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c,
  0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068,
  0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034,
  0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000,
  0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc,
  0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98,
  0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000, 0xff83, 0xff54, 0xfe60,
  0xfe86, 0xff02, 0x0080, 0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4,
  0xff04, 0xff81, 0x0000, 0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc,
  0xff82, 0x0000, 0xff80, 0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c,
  0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668,
  0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634,
  0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00,
  0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc,
  0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0,
  0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8,
  0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0,
  0x3e82, 0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0,
  0x3f01, 0x4000, 0x3f01, 0x3e04, 0x3d09, 0x1ce4, 0x0a90, 0x0040,
  0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018,
  0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010,
  0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068, 0x0008,
  0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000,
  0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8,
  0xe634, 0x0400, 0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0,
  0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0,
  0xfe83, 0x0100, 0x007f, 0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68,
  0xff02, 0x0080, 0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58,
  0xff81, 0x0000, 0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18,
  0x0000, 0xff80, 0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10,
  0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08,
  0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400,
  0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8,
  0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a,
  0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177,
  0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102,
  0xc100, 0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c,
  0xc080, 0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018,
  0x4000, 0x3f01, 0x3e04, 0x3d09, 0x1ce4, 0x0a90, 0x0040, 0x0009,
  0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006,
  0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010, 0x0003,
  0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068, 0x0008, 0x0000,
  0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd,
  0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa,
  0x0400, 0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8,
  0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67,
  0x0100, 0x007f, 0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01,
  0x0080, 0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89,
  0x0000, 0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86,
  0xff80, 0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83,
  0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180,
  0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d,
  0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc,
  0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa,
  0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac,
  0xc17e, 0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068,
  0xc0ff, 0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010,
  0x3f80, 0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006,
  0x3f01, 0x3e04, 0x3d09, 0x1ce4, 0x0a90, 0x0040, 0x0009, 0x0004,
  0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006, 0x0002,
  0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010, 0x0003, 0x0000,
  0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068, 0x0008, 0x0000, 0xfffe,
  0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc,
  0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0,
  0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a,
  0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56,
  0x007f, 0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06,
  0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04,
  0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02,
  0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100,
  0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe,
  0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e,
  0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc, 0x007d,
  0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056,
  0xc1fc, 0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034,
  0xc17e, 0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068, 0x0008,
  0x3f00, 0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010, 0x0003,
  0x3e82, 0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006, 0x0002,
  0x3e04, 0x3d09, 0x1ce4, 0x0a90, 0x0040, 0x0009, 0x0004, 0x0001,
  0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006, 0x0002, 0x0000,
  0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010, 0x0003, 0x0000, 0xffff,
  0x1998, 0x03e8, 0x0102, 0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe,
  0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8,
  0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd,
  0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab,
  0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56, 0xff83,
  0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82,
  0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81,
  0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080,
  0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f,
  0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000,
  0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000,
  0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc, 0x007d, 0x0000,
  0xc27a, 0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000,
  0xc1fd, 0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000,
  0x3e80, 0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068, 0x0008, 0x0000,
  0x3e03, 0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010, 0x0003, 0x0000,
  0x3d86, 0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006, 0x0002, 0x0000,
  0x3d09, 0x1ce4, 0x0a90, 0x0040, 0x0009, 0x0004, 0x0001, 0x0000,
  0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006, 0x0002, 0x0000, 0x0000,
  0x1964, 0x02b0, 0x009c, 0x0010, 0x0003, 0x0000, 0xffff, 0x0000,
  0x03e8, 0x0102, 0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000,
  0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000,
  0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000,
  0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000,
  0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56, 0xff83, 0x0000,
  0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82, 0x0000,
  0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000,
  0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000,
  0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000, 0xff82,
  0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000, 0xff83,
  0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa,
  0xd5ac, 0xe634, 0x0400, 0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc,
  0xd556, 0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8,
  0x2b00, 0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd,
  0x2aaa, 0x1998, 0x03e8, 0x0102, 0x0068, 0x0008, 0x0000, 0xfffe,
  0x2a54, 0x1964, 0x02b0, 0x009c, 0x0010, 0x0003, 0x0000, 0xffff,
  0x29fe, 0x1178, 0x01a0, 0x0018, 0x0006, 0x0002, 0x0000, 0x0000,
  0x1ce4, 0x0a90, 0x0040, 0x0009, 0x0004, 0x0001, 0x0000, 0x0001,
  0x1178, 0x01a0, 0x0018, 0x0006, 0x0002, 0x0000, 0x0000, 0x0002,
  0x02b0, 0x009c, 0x0010, 0x0003, 0x0000, 0xffff, 0x0000, 0x0008,
  0x0102, 0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033,
  0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055,
  0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d,
  0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e,
  0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56, 0xff83, 0x0000, 0x007f,
  0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82, 0x0000, 0xff80,
  0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000, 0xff81,
  0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000, 0xff81, 0xff04,
  0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000, 0xff82, 0xff06,
  0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000, 0xff83, 0xff54,
  0xe668, 0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98,
  0xe634, 0x0400, 0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0,
  0x1a00, 0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa,
  0x19cc, 0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc,
  0x1998, 0x03e8, 0x0102, 0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe,
  0x1964, 0x02b0, 0x009c, 0x0010, 0x0003, 0x0000, 0xffff, 0x0000,
  0x1178, 0x01a0, 0x0018, 0x0006, 0x0002, 0x0000, 0x0000, 0x0002,
  0x0a90, 0x0040, 0x0009, 0x0004, 0x0001, 0x0000, 0x0001, 0x0004,
  0x01a0, 0x0018, 0x0006, 0x0002, 0x0000, 0x0000, 0x0002, 0x0010,
  0x009c, 0x0010, 0x0003, 0x0000, 0xffff, 0x0000, 0x0008, 0x0066,
  0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa,
  0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa,
  0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc,
  0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe,
  0xff98, 0xffc0, 0xff67, 0xff56, 0xff83, 0x0000, 0x007f, 0xff00,
  0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82, 0x0000, 0xff80, 0xff02,
  0xfe68, 0xff01, 0xff06, 0xff82, 0x0000, 0xff80, 0xff02, 0xfc10,
  0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000, 0xff81, 0xff04, 0xfc18,
  0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000, 0xff82, 0xff06, 0xfd50,
  0xfc10, 0xfe83, 0x0100, 0x007f, 0x0000, 0xff83, 0xff54, 0xfe60,
  0xfc08, 0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0,
  0x0400, 0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8,
  0x03f8, 0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0,
  0x03f0, 0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8,
  0x03e8, 0x0102, 0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000,
  0x02b0, 0x009c, 0x0010, 0x0003, 0x0000, 0xffff, 0x0000, 0x0008,
  0x01a0, 0x0018, 0x0006, 0x0002, 0x0000, 0x0000, 0x0002, 0x0010,
  0x0040, 0x0009, 0x0004, 0x0001, 0x0000, 0x0001, 0x0004, 0x0040,
  0x0018, 0x0006, 0x0002, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198,
  0x0010, 0x0003, 0x0000, 0xffff, 0x0000, 0x0008, 0x0066, 0x02a8,
  0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8,
  0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0,
  0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8,
  0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00,
  0xffc0, 0xff67, 0xff56, 0xff83, 0x0000, 0x007f, 0xff00, 0xfc08,
  0xff67, 0xff56, 0xff83, 0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6,
  0xff01, 0xff06, 0xff82, 0x0000, 0xff80, 0xff02, 0xfc10, 0xe719,
  0xfe89, 0xff04, 0xff81, 0x0000, 0xff81, 0xff04, 0xfc18, 0xeede,
  0xfe86, 0xff02, 0x0080, 0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4,
  0xfe83, 0x0100, 0x007f, 0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68,
  0x0180, 0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67,
  0x017d, 0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a,
  0x017a, 0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd,
  0x0177, 0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000,
  0x0102, 0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033,
  0x009c, 0x0010, 0x0003, 0x0000, 0xffff, 0x0000, 0x0008, 0x0066,
  0x0018, 0x0006, 0x0002, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198,
  0x0009, 0x0004, 0x0001, 0x0000, 0x0001, 0x0004, 0x0040, 0x0a29,
  0x0006, 0x0002, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef,
  0x0003, 0x0000, 0xffff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7,
  0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a,
  0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d,
  0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680,
  0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3,
  0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a,
  0xff56, 0xff83, 0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f,
  0xff06, 0xff82, 0x0000, 0xff80, 0xff02, 0xfc10, 0xe719, 0xe372,
  0xff04, 0xff81, 0x0000, 0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc,
  0xff02, 0x0080, 0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58,
  0x0100, 0x007f, 0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01,
  0x00fe, 0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56,
  0x00fc, 0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab,
  0x00fa, 0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000,
  0x00ac, 0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055,
  0x0068, 0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa,
  0x0010, 0x0003, 0x0000, 0xffff, 0x0000, 0x0008, 0x0066, 0x02a8,
  0x0006, 0x0002, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef,
  0x0004, 0x0001, 0x0000, 0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39,
  0x0002, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981,
  0x0000, 0xffff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6,
  0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b,
  0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580,
  0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5,
  0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a,
  0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7,
  0xff83, 0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602,
  0xff82, 0x0000, 0xff80, 0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c,
  0xff81, 0x0000, 0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18,
  0x0080, 0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89,
  0x007f, 0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06,
  0x007e, 0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56, 0xff83,
  0x007d, 0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000,
  0x0056, 0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d,
  0x0034, 0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa,
  0x0008, 0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8,
  0x0003, 0x0000, 0xffff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7,
  0x0002, 0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981,
  0x0001, 0x0000, 0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86,
  0xffff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03,
  0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180,
  0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd,
  0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc,
  0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a,
  0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac,
  0x0000, 0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668,
  0x0000, 0xff80, 0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10,
  0x0000, 0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86,
  0x0000, 0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04,
  0x0000, 0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82,
  0x0000, 0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56, 0xff83, 0x0000,
  0x0000, 0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e,
  0x0000, 0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc,
  0x0000, 0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0,
  0x0000, 0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a,
  0x0000, 0xffff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6,
  0x0000, 0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86,
  0x0000, 0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04,
  0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82,
  0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100,
  0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e,
  0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e,
  0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd,
  0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556,
  0x007e, 0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634,
  0x007f, 0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08,
  0xff80, 0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83,
  0xff81, 0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02,
  0xff82, 0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81,
  0xff83, 0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82, 0x0000,
  0xffaa, 0xff98, 0xffc0, 0xff67, 0xff56, 0xff83, 0x0000, 0x007f,
  0xffcc, 0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe,
  0xfff8, 0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8,
  0xfffd, 0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d,
  0xfffe, 0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b,
  0xffff, 0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03,
  0x0000, 0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82,
  0x0001, 0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01,
  0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080,
  0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff,
  0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00,
  0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80,
  0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00,
  0x00fc, 0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00,
  0x00fe, 0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400,
  0xff00, 0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180,
  0xff02, 0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100,
  0xff04, 0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080,
  0xff06, 0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000,
  0xff54, 0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82, 0x0000, 0xff80,
  0xff98, 0xffc0, 0xff67, 0xff56, 0xff83, 0x0000, 0x007f, 0xff00,
  0xfff0, 0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00,
  0xfffa, 0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680,
  0xfffc, 0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580,
  0xfffe, 0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180,
  0x0000, 0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100,
  0x0002, 0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080,
  0x0004, 0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000,
  0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80,
  0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80, 0x3e82,
  0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff, 0x3f00, 0x3e03,
  0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e, 0xc17e, 0x3e80, 0x2aaa,
  0x03f0, 0x194d, 0xd580, 0xc1fd, 0xc1fc, 0xc1fd, 0x2b00, 0x19cc,
  0x03f8, 0xe680, 0xd5d5, 0xc27a, 0xc27a, 0xd556, 0x1a00, 0x03f8,
  0xfc00, 0xe6b3, 0xd62a, 0xc2f7, 0xd5ac, 0xe634, 0x0400, 0x017d,
  0xfc08, 0xe6e6, 0xd67f, 0xd602, 0xe668, 0xfc08, 0x0180, 0x00fe,
  0xfc10, 0xe719, 0xe372, 0xe69c, 0xfc10, 0xfe83, 0x0100, 0x007f,
  0xfc18, 0xeede, 0xeebc, 0xfc18, 0xfe86, 0xff02, 0x0080, 0x0000,
  0xfd50, 0xf5a4, 0xfd58, 0xfe89, 0xff04, 0xff81, 0x0000, 0xff81,
  0xfe60, 0xfe68, 0xff01, 0xff06, 0xff82, 0x0000, 0xff80, 0xff02,
  0xffc0, 0xff67, 0xff56, 0xff83, 0x0000, 0x007f, 0xff00, 0xfc08,
  0xffe8, 0xff9a, 0xffab, 0x0000, 0x007e, 0x00fe, 0xfc00, 0xe6b3,
  0xfff0, 0xffcd, 0x0000, 0x007d, 0x00fc, 0x03f8, 0xe680, 0xd5d5,
  0xfff8, 0x0000, 0x0055, 0x00fa, 0x03f0, 0x194d, 0xd580, 0xc1fd,
  0x0000, 0x0033, 0x00aa, 0x03e8, 0x191a, 0x2a2b, 0xc180, 0xc17e,
  0x0008, 0x0066, 0x02a8, 0x18e7, 0x29d6, 0x3e03, 0xc100, 0xc0ff,
  0x0010, 0x0198, 0x10ef, 0x2981, 0x3d86, 0x3e82, 0xc080, 0x3f80,
  0x0040, 0x0a29, 0x1c39, 0x3d09, 0x3e04, 0x3f01, 0x4000, 0x3f01,
};
const unsigned kExpectedCount_NEON_smull_8H = 361;

#endif  // VIXL_SIM_SMULL_8H_TRACE_AARCH64_H_
