/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "timelabel.h"
#include "QApplication"
#include <QDebug>
#include <QDateTime>

TimeLabel::TimeLabel(QWidget *parent) :
    FixLabel(parent)
{
    QFont font = QApplication::font();
    if (QLocale::system().amText() == "སྔ་དྲོ་") {
        font.setPixelSize(font.pointSize() * 20 / 11);
    } else {
        font.setPixelSize(font.pointSize() * 28 / 11);
    }
    font.setWeight(QFont::Medium);
    font.setBold(true);
    this->setFont(font);
    this->setAlignment(Qt::AlignVCenter);
    this->setContentsMargins(0, 0, 0, 0);
    this->setObjectName("timeClockLable");
    timerID = startTimer(1000);

    areaInterface = new QDBusInterface("org.ukui.ukcc.session",
                                       "/Area",
                                       "org.ukui.ukcc.session.Area",
                                       QDBusConnection::sessionBus(),
                                       this);
    if (areaInterface) {
        timeFormat = areaInterface->property("timeFormat").toString();
    } else {
        if (!areaInterface->isValid()) {
            qCritical() << "org.ukui.ukcc.session.Area DBus error:" << areaInterface->lastError();
        }
    }
    setTimeText();
}

TimeLabel::~TimeLabel()
{
    killTimer(timerID);
}

void TimeLabel::timerEvent(QTimerEvent *e)
{
    if (e->timerId() == timerID) {
        setTimeText();
    }
}

void TimeLabel::setTimeText()
{
    QString currentsecStr;
    QDateTime datetime = QDateTime::currentDateTime();
    if (areaInterface->property("timeFormat").toString() == "24") {
        currentsecStr = datetime.toString("hh : mm : ss");
    } else {
        if (QLocale::system().amText() == QString("上午") || QLocale::system().amText() == QString("སྔ་དྲོ་")) {
            currentsecStr = datetime.toString("AP hh: mm : ss");
        } else {
            currentsecStr = datetime.toString("hh: mm : ss AP");
        }
    }
    QString dateString;
    if ("cn" == areaInterface->property("dateFormat").toString()) {
        dateString = datetime.toString("yyyy/MM/dd ddd").replace("周", "星期");
    } else {
        dateString = datetime.toString("yyyy-MM-dd ddd").replace("周", "星期");
    }
    if (dateString != date) {
        date = dateString;
        Q_EMIT dateChanged();
    }
    setText(currentsecStr);
}

QString TimeLabel::dateText()
{
    return date;
}
