#define SYSTEM_CTRL                                   0x000000
#define SYSTEM_CTRL_DPMS                              31:30
#define SYSTEM_CTRL_DPMS_VPHP                         0
#define SYSTEM_CTRL_DPMS_VPHN                         1
#define SYSTEM_CTRL_DPMS_VNHP                         2
#define SYSTEM_CTRL_DPMS_VNHN                         3
#define SYSTEM_CTRL_PCI_BURST                         29:29
#define SYSTEM_CTRL_PCI_BURST_OFF                     0
#define SYSTEM_CTRL_PCI_BURST_ON                      1
#define SYSTEM_CTRL_PCI_MASTER                        25:25
#define SYSTEM_CTRL_PCI_MASTER_OFF                    0
#define SYSTEM_CTRL_PCI_MASTER_ON                     1
#define SYSTEM_CTRL_LATENCY_TIMER                     24:24
#define SYSTEM_CTRL_LATENCY_TIMER_ON                  0
#define SYSTEM_CTRL_LATENCY_TIMER_OFF                 1
#define SYSTEM_CTRL_DE_FIFO                           23:23
#define SYSTEM_CTRL_DE_FIFO_NOTEMPTY                  0
#define SYSTEM_CTRL_DE_FIFO_EMPTY                     1
#define SYSTEM_CTRL_DE_STATUS                         22:22
#define SYSTEM_CTRL_DE_STATUS_IDLE                    0
#define SYSTEM_CTRL_DE_STATUS_BUSY                    1
#define SYSTEM_CTRL_DE_MEM_FIFO                       21:21
#define SYSTEM_CTRL_DE_MEM_FIFO_NOTEMPTY              0
#define SYSTEM_CTRL_DE_MEM_FIFO_EMPTY                 1
#define SYSTEM_CTRL_CSC_STATUS                        20:20
#define SYSTEM_CTRL_CSC_STATUS_IDLE                   0
#define SYSTEM_CTRL_CSC_STATUS_BUSY                   1
#define SYSTEM_CTRL_SECONDARY_VSYNC                   19:19
#define SYSTEM_CTRL_SECONDARY_VSYNC_INACTIVE          0
#define SYSTEM_CTRL_SECONDARY_VSYNC_ACTIVE            1
#define SYSTEM_CTRL_PRIMARY_VSYNC                     18:18
#define SYSTEM_CTRL_PRIMARY_VSYNC_INACTIVE            0
#define SYSTEM_CTRL_PRIMARY_VSYNC_ACTIVE              1
#define SYSTEM_CTRL_CURRENT_BUFFER                    17:17
#define SYSTEM_CTRL_CURRENT_BUFFER_NORMAL             0
#define SYSTEM_CTRL_CURRENT_BUFFER_FLIP_PENDING       1
#define SYSTEM_CTRL_DMA_STATUS                        16:16
#define SYSTEM_CTRL_DMA_STATUS_IDLE                   0
#define SYSTEM_CTRL_DMA_STATUS_BUSY                   1
#define SYSTEM_CTRL_PCI_BURST_READ                    15:15
#define SYSTEM_CTRL_PCI_BURST_READ_OFF                0
#define SYSTEM_CTRL_PCI_BURST_READ_ON                 1
#define SYSTEM_CTRL_DE_ABORT                          13:13
#define SYSTEM_CTRL_DE_ABORT_OFF                      0
#define SYSTEM_CTRL_DE_ABORT_ON                       1
#define SYSTEM_CTRL_PCI_SUBSYS_ID_LOCK                11:11
#define SYSTEM_CTRL_PCI_SUBSYS_ID_LOCK_OFF            0
#define SYSTEM_CTRL_PCI_SUBSYS_ID_LOCK_ON             1
#define SYSTEM_CTRL_PCI_RETRY                         7:7
#define SYSTEM_CTRL_PCI_RETRY_ON                      0
#define SYSTEM_CTRL_PCI_RETRY_OFF                     1
#define SYSTEM_CTRL_PCI_SLAVE_BURST_READ_SIZE         5:4
#define SYSTEM_CTRL_PCI_SLAVE_BURST_READ_SIZE_1       0
#define SYSTEM_CTRL_PCI_SLAVE_BURST_READ_SIZE_2       1
#define SYSTEM_CTRL_PCI_SLAVE_BURST_READ_SIZE_4       2
#define SYSTEM_CTRL_PCI_SLAVE_BURST_READ_SIZE_8       3
#define SYSTEM_CTRL_CRT_TRISTATE                      3:3
#define SYSTEM_CTRL_CRT_TRISTATE_OFF                  0
#define SYSTEM_CTRL_CRT_TRISTATE_ON                   1
#define SYSTEM_CTRL_PCIMEM_TRISTATE                   2:2
#define SYSTEM_CTRL_PCIMEM_TRISTATE_OFF               0
#define SYSTEM_CTRL_PCIMEM_TRISTATE_ON                1
#define SYSTEM_CTRL_LOCALMEM_TRISTATE                 1:1
#define SYSTEM_CTRL_LOCALMEM_TRISTATE_OFF             0
#define SYSTEM_CTRL_LOCALMEM_TRISTATE_ON              1
#define SYSTEM_CTRL_PANEL_TRISTATE                    0:0
#define SYSTEM_CTRL_PANEL_TRISTATE_OFF                0
#define SYSTEM_CTRL_PANEL_TRISTATE_ON                 1

#define MISC_CTRL                                     0x000004
#define MISC_CTRL_DRAM_RERESH_COUNT                   27:27
#define MISC_CTRL_DRAM_RERESH_COUNT_1ROW              0
#define MISC_CTRL_DRAM_RERESH_COUNT_3ROW              1
#define MISC_CTRL_DRAM_REFRESH_TIME                   26:25
#define MISC_CTRL_DRAM_REFRESH_TIME_8                 0
#define MISC_CTRL_DRAM_REFRESH_TIME_16                1
#define MISC_CTRL_DRAM_REFRESH_TIME_32                2
#define MISC_CTRL_DRAM_REFRESH_TIME_64                3
#define MISC_CTRL_INT_OUTPUT                          24:24
#define MISC_CTRL_INT_OUTPUT_NORMAL                   0
#define MISC_CTRL_INT_OUTPUT_INVERT                   1
#define MISC_CTRL_PLL_CLK_COUNT                       23:23
#define MISC_CTRL_PLL_CLK_COUNT_OFF                   0
#define MISC_CTRL_PLL_CLK_COUNT_ON                    1
#define MISC_CTRL_DAC_POWER                           20:20
#define MISC_CTRL_DAC_POWER_ON                        0
#define MISC_CTRL_DAC_POWER_OFF                       1
#define MISC_CTRL_CLK_SELECT                          16:16
#define MISC_CTRL_CLK_SELECT_OSC                      0
#define MISC_CTRL_CLK_SELECT_TESTCLK                  1
#define MISC_CTRL_DRAM_COLUMN_SIZE                    15:14
#define MISC_CTRL_DRAM_COLUMN_SIZE_256                0
#define MISC_CTRL_DRAM_COLUMN_SIZE_512                1
#define MISC_CTRL_DRAM_COLUMN_SIZE_1024               2
#define MISC_CTRL_LOCALMEM_SIZE                       13:12
#define MISC_CTRL_LOCALMEM_SIZE_8M                    3
#define MISC_CTRL_LOCALMEM_SIZE_16M                   0
#define MISC_CTRL_LOCALMEM_SIZE_32M                   1
#define MISC_CTRL_LOCALMEM_SIZE_64M                   2
#define MISC_CTRL_DRAM_TWTR                           11:11
#define MISC_CTRL_DRAM_TWTR_2CLK                      0
#define MISC_CTRL_DRAM_TWTR_1CLK                      1
#define MISC_CTRL_DRAM_TWR                            10:10
#define MISC_CTRL_DRAM_TWR_3CLK                       0
#define MISC_CTRL_DRAM_TWR_2CLK                       1
#define MISC_CTRL_DRAM_TRP                            9:9
#define MISC_CTRL_DRAM_TRP_3CLK                       0
#define MISC_CTRL_DRAM_TRP_4CLK                       1
#define MISC_CTRL_DRAM_TRFC                           8:8
#define MISC_CTRL_DRAM_TRFC_12CLK                     0
#define MISC_CTRL_DRAM_TRFC_14CLK                     1
#define MISC_CTRL_DRAM_TRAS                           7:7
#define MISC_CTRL_DRAM_TRAS_7CLK                      0
#define MISC_CTRL_DRAM_TRAS_8CLK                      1
#define MISC_CTRL_LOCALMEM_RESET                      6:6
#define MISC_CTRL_LOCALMEM_RESET_RESET                0
#define MISC_CTRL_LOCALMEM_RESET_NORMAL               1
#define MISC_CTRL_LOCALMEM_STATE                      5:5
#define MISC_CTRL_LOCALMEM_STATE_ACTIVE               0
#define MISC_CTRL_LOCALMEM_STATE_INACTIVE             1
#define MISC_CTRL_CPU_CAS_LATENCY                     4:4
#define MISC_CTRL_CPU_CAS_LATENCY_2CLK                0
#define MISC_CTRL_CPU_CAS_LATENCY_3CLK                1
#define MISC_CTRL_DLL                                 3:3
#define MISC_CTRL_DLL_ON                              0
#define MISC_CTRL_DLL_OFF                             1
#define MISC_CTRL_DRAM_OUTPUT                         2:2
#define MISC_CTRL_DRAM_OUTPUT_LOW                     0
#define MISC_CTRL_DRAM_OUTPUT_HIGH                    1
#define MISC_CTRL_LOCALMEM_BUS_SIZE                   1:1
#define MISC_CTRL_LOCALMEM_BUS_SIZE_32                0
#define MISC_CTRL_LOCALMEM_BUS_SIZE_64                1
#define MISC_CTRL_EMBEDDED_LOCALMEM                   0:0
#define MISC_CTRL_EMBEDDED_LOCALMEM_ON                0
#define MISC_CTRL_EMBEDDED_LOCALMEM_OFF               1

#define GPIO_MUX                                      0x000008
#define GPIO_MUX_31                                   31:31
#define GPIO_MUX_31_GPIO                              0
#define GPIO_MUX_31_I2C                               1
#define GPIO_MUX_30                                   30:30
#define GPIO_MUX_30_GPIO                              0
#define GPIO_MUX_30_I2C                               1
#define GPIO_MUX_29                                   29:29
#define GPIO_MUX_29_GPIO                              0
#define GPIO_MUX_29_SSP1                              1
#define GPIO_MUX_28                                   28:28
#define GPIO_MUX_28_GPIO                              0
#define GPIO_MUX_28_SSP1                              1
#define GPIO_MUX_27                                   27:27
#define GPIO_MUX_27_GPIO                              0
#define GPIO_MUX_27_SSP1                              1
#define GPIO_MUX_26                                   26:26
#define GPIO_MUX_26_GPIO                              0
#define GPIO_MUX_26_SSP1                              1
#define GPIO_MUX_25                                   25:25
#define GPIO_MUX_25_GPIO                              0
#define GPIO_MUX_25_SSP1                              1
#define GPIO_MUX_24                                   24:24
#define GPIO_MUX_24_GPIO                              0
#define GPIO_MUX_24_SSP0                              1
#define GPIO_MUX_23                                   23:23
#define GPIO_MUX_23_GPIO                              0
#define GPIO_MUX_23_SSP0                              1
#define GPIO_MUX_22                                   22:22
#define GPIO_MUX_22_GPIO                              0
#define GPIO_MUX_22_SSP0                              1
#define GPIO_MUX_21                                   21:21
#define GPIO_MUX_21_GPIO                              0
#define GPIO_MUX_21_SSP0                              1
#define GPIO_MUX_20                                   20:20
#define GPIO_MUX_20_GPIO                              0
#define GPIO_MUX_20_SSP0                              1
#define GPIO_MUX_19                                   19:19
#define GPIO_MUX_19_GPIO                              0
#define GPIO_MUX_19_PWM                               1
#define GPIO_MUX_18                                   18:18
#define GPIO_MUX_18_GPIO                              0
#define GPIO_MUX_18_PWM                               1
#define GPIO_MUX_17                                   17:17
#define GPIO_MUX_17_GPIO                              0
#define GPIO_MUX_17_PWM                               1
#define GPIO_MUX_16                                   16:16
#define GPIO_MUX_16_GPIO_ZVPORT                       0
#define GPIO_MUX_16_TEST_DATA                         1
#define GPIO_MUX_15                                   15:15
#define GPIO_MUX_15_GPIO_ZVPORT                       0
#define GPIO_MUX_15_TEST_DATA                         1
#define GPIO_MUX_14                                   14:14
#define GPIO_MUX_14_GPIO_ZVPORT                       0
#define GPIO_MUX_14_TEST_DATA                         1
#define GPIO_MUX_13                                   13:13
#define GPIO_MUX_13_GPIO_ZVPORT                       0
#define GPIO_MUX_13_TEST_DATA                         1
#define GPIO_MUX_12                                   12:12
#define GPIO_MUX_12_GPIO_ZVPORT                       0
#define GPIO_MUX_12_TEST_DATA                         1
#define GPIO_MUX_11                                   11:11
#define GPIO_MUX_11_GPIO_ZVPORT                       0
#define GPIO_MUX_11_TEST_DATA                         1
#define GPIO_MUX_10                                   10:10
#define GPIO_MUX_10_GPIO_ZVPORT                       0
#define GPIO_MUX_10_TEST_DATA                         1
#define GPIO_MUX_9                                    9:9
#define GPIO_MUX_9_GPIO_ZVPORT                        0
#define GPIO_MUX_9_TEST_DATA                          1
#define GPIO_MUX_8                                    8:8
#define GPIO_MUX_8_GPIO_ZVPORT                        0
#define GPIO_MUX_8_TEST_DATA                          1
#define GPIO_MUX_7                                    7:7
#define GPIO_MUX_7_GPIO_ZVPORT                        0
#define GPIO_MUX_7_TEST_DATA                          1
#define GPIO_MUX_6                                    6:6
#define GPIO_MUX_6_GPIO_ZVPORT                        0
#define GPIO_MUX_6_TEST_DATA                          1
#define GPIO_MUX_5                                    5:5
#define GPIO_MUX_5_GPIO_ZVPORT                        0
#define GPIO_MUX_5_TEST_DATA                          1
#define GPIO_MUX_4                                    4:4
#define GPIO_MUX_4_GPIO_ZVPORT                        0
#define GPIO_MUX_4_TEST_DATA                          1
#define GPIO_MUX_3                                    3:3
#define GPIO_MUX_3_GPIO_ZVPORT                        0
#define GPIO_MUX_3_TEST_DATA                          1
#define GPIO_MUX_2                                    2:2
#define GPIO_MUX_2_GPIO_ZVPORT                        0
#define GPIO_MUX_2_TEST_DATA                          1
#define GPIO_MUX_1                                    1:1
#define GPIO_MUX_1_GPIO_ZVPORT                        0
#define GPIO_MUX_1_TEST_DATA                          1
#define GPIO_MUX_0                                    0:0
#define GPIO_MUX_0_GPIO_ZVPORT                        0
#define GPIO_MUX_0_TEST_DATA                          1

#define LOCALMEM_ARBITRATION                          0x00000C
#define LOCALMEM_ARBITRATION_ROTATE                   28:28
#define LOCALMEM_ARBITRATION_ROTATE_OFF               0
#define LOCALMEM_ARBITRATION_ROTATE_ON                1
#define LOCALMEM_ARBITRATION_VGA                      26:24
#define LOCALMEM_ARBITRATION_VGA_OFF                  0
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_1           1
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_2           2
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_3           3
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_4           4
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_5           5
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_6           6
#define LOCALMEM_ARBITRATION_VGA_PRIORITY_7           7
#define LOCALMEM_ARBITRATION_DMA                      22:20
#define LOCALMEM_ARBITRATION_DMA_OFF                  0
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_1           1
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_2           2
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_3           3
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_4           4
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_5           5
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_6           6
#define LOCALMEM_ARBITRATION_DMA_PRIORITY_7           7
#define LOCALMEM_ARBITRATION_ZVPORT1                  18:16
#define LOCALMEM_ARBITRATION_ZVPORT1_OFF              0
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_1       1
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_2       2
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_3       3
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_4       4
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_5       5
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_6       6
#define LOCALMEM_ARBITRATION_ZVPORT1_PRIORITY_7       7
#define LOCALMEM_ARBITRATION_ZVPORT0                  14:12
#define LOCALMEM_ARBITRATION_ZVPORT0_OFF              0
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_1       1
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_2       2
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_3       3
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_4       4
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_5       5
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_6       6
#define LOCALMEM_ARBITRATION_ZVPORT0_PRIORITY_7       7
#define LOCALMEM_ARBITRATION_VIDEO                    10:8
#define LOCALMEM_ARBITRATION_VIDEO_OFF                0
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_1         1
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_2         2
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_3         3
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_4         4
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_5         5
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_6         6
#define LOCALMEM_ARBITRATION_VIDEO_PRIORITY_7         7
#define LOCALMEM_ARBITRATION_PANEL                    6:4
#define LOCALMEM_ARBITRATION_PANEL_OFF                0
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_1         1
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_2         2
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_3         3
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_4         4
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_5         5
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_6         6
#define LOCALMEM_ARBITRATION_PANEL_PRIORITY_7         7
#define LOCALMEM_ARBITRATION_CRT                      2:0
#define LOCALMEM_ARBITRATION_CRT_OFF                  0
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_1           1
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_2           2
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_3           3
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_4           4
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_5           5
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_6           6
#define LOCALMEM_ARBITRATION_CRT_PRIORITY_7           7

#define PCIMEM_ARBITRATION                            0x000010
#define PCIMEM_ARBITRATION_ROTATE                     28:28
#define PCIMEM_ARBITRATION_ROTATE_OFF                 0
#define PCIMEM_ARBITRATION_ROTATE_ON                  1
#define PCIMEM_ARBITRATION_VGA                        26:24
#define PCIMEM_ARBITRATION_VGA_OFF                    0
#define PCIMEM_ARBITRATION_VGA_PRIORITY_1             1
#define PCIMEM_ARBITRATION_VGA_PRIORITY_2             2
#define PCIMEM_ARBITRATION_VGA_PRIORITY_3             3
#define PCIMEM_ARBITRATION_VGA_PRIORITY_4             4
#define PCIMEM_ARBITRATION_VGA_PRIORITY_5             5
#define PCIMEM_ARBITRATION_VGA_PRIORITY_6             6
#define PCIMEM_ARBITRATION_VGA_PRIORITY_7             7
#define PCIMEM_ARBITRATION_DMA                        22:20
#define PCIMEM_ARBITRATION_DMA_OFF                    0
#define PCIMEM_ARBITRATION_DMA_PRIORITY_1             1
#define PCIMEM_ARBITRATION_DMA_PRIORITY_2             2
#define PCIMEM_ARBITRATION_DMA_PRIORITY_3             3
#define PCIMEM_ARBITRATION_DMA_PRIORITY_4             4
#define PCIMEM_ARBITRATION_DMA_PRIORITY_5             5
#define PCIMEM_ARBITRATION_DMA_PRIORITY_6             6
#define PCIMEM_ARBITRATION_DMA_PRIORITY_7             7
#define PCIMEM_ARBITRATION_ZVPORT1                    18:16
#define PCIMEM_ARBITRATION_ZVPORT1_OFF                0
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_1         1
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_2         2
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_3         3
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_4         4
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_5         5
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_6         6
#define PCIMEM_ARBITRATION_ZVPORT1_PRIORITY_7         7
#define PCIMEM_ARBITRATION_ZVPORT0                    14:12
#define PCIMEM_ARBITRATION_ZVPORT0_OFF                0
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_1         1
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_2         2
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_3         3
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_4         4
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_5         5
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_6         6
#define PCIMEM_ARBITRATION_ZVPORT0_PRIORITY_7         7
#define PCIMEM_ARBITRATION_VIDEO                      10:8
#define PCIMEM_ARBITRATION_VIDEO_OFF                  0
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_1           1
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_2           2
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_3           3
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_4           4
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_5           5
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_6           6
#define PCIMEM_ARBITRATION_VIDEO_PRIORITY_7           7
#define PCIMEM_ARBITRATION_PANEL                      6:4
#define PCIMEM_ARBITRATION_PANEL_OFF                  0
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_1           1
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_2           2
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_3           3
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_4           4
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_5           5
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_6           6
#define PCIMEM_ARBITRATION_PANEL_PRIORITY_7           7
#define PCIMEM_ARBITRATION_CRT                        2:0
#define PCIMEM_ARBITRATION_CRT_OFF                    0
#define PCIMEM_ARBITRATION_CRT_PRIORITY_1             1
#define PCIMEM_ARBITRATION_CRT_PRIORITY_2             2
#define PCIMEM_ARBITRATION_CRT_PRIORITY_3             3
#define PCIMEM_ARBITRATION_CRT_PRIORITY_4             4
#define PCIMEM_ARBITRATION_CRT_PRIORITY_5             5
#define PCIMEM_ARBITRATION_CRT_PRIORITY_6             6
#define PCIMEM_ARBITRATION_CRT_PRIORITY_7             7

#define RAW_INT                                       0x000020
#define RAW_INT_ZVPORT1_VSYNC                         4:4
#define RAW_INT_ZVPORT1_VSYNC_INACTIVE                0
#define RAW_INT_ZVPORT1_VSYNC_ACTIVE                  1
#define RAW_INT_ZVPORT1_VSYNC_CLEAR                   1
#define RAW_INT_ZVPORT0_VSYNC                         3:3
#define RAW_INT_ZVPORT0_VSYNC_INACTIVE                0
#define RAW_INT_ZVPORT0_VSYNC_ACTIVE                  1
#define RAW_INT_ZVPORT0_VSYNC_CLEAR                   1
#define RAW_INT_SECONDARY_VSYNC                       2:2
#define RAW_INT_SECONDARY_VSYNC_INACTIVE              0
#define RAW_INT_SECONDARY_VSYNC_ACTIVE                1
#define RAW_INT_SECONDARY_VSYNC_CLEAR                 1
#define RAW_INT_PRIMARY_VSYNC                         1:1
#define RAW_INT_PRIMARY_VSYNC_INACTIVE                0
#define RAW_INT_PRIMARY_VSYNC_ACTIVE                  1
#define RAW_INT_PRIMARY_VSYNC_CLEAR                   1
#define RAW_INT_VGA_VSYNC                             0:0
#define RAW_INT_VGA_VSYNC_INACTIVE                    0
#define RAW_INT_VGA_VSYNC_ACTIVE                      1
#define RAW_INT_VGA_VSYNC_CLEAR                       1

#define INT_STATUS                                    0x000024
#define INT_STATUS_GPIO31                             31:31
#define INT_STATUS_GPIO31_INACTIVE                    0
#define INT_STATUS_GPIO31_ACTIVE                      1
#define INT_STATUS_GPIO30                             30:30
#define INT_STATUS_GPIO30_INACTIVE                    0
#define INT_STATUS_GPIO30_ACTIVE                      1
#define INT_STATUS_GPIO29                             29:29
#define INT_STATUS_GPIO29_INACTIVE                    0
#define INT_STATUS_GPIO29_ACTIVE                      1
#define INT_STATUS_GPIO28                             28:28
#define INT_STATUS_GPIO28_INACTIVE                    0
#define INT_STATUS_GPIO28_ACTIVE                      1
#define INT_STATUS_GPIO27                             27:27
#define INT_STATUS_GPIO27_INACTIVE                    0
#define INT_STATUS_GPIO27_ACTIVE                      1
#define INT_STATUS_GPIO26                             26:26
#define INT_STATUS_GPIO26_INACTIVE                    0
#define INT_STATUS_GPIO26_ACTIVE                      1
#define INT_STATUS_GPIO25                             25:25
#define INT_STATUS_GPIO25_INACTIVE                    0
#define INT_STATUS_GPIO25_ACTIVE                      1
#define INT_STATUS_I2C                                12:12
#define INT_STATUS_I2C_INACTIVE                       0
#define INT_STATUS_I2C_ACTIVE                         1
#define INT_STATUS_PWM                                11:11
#define INT_STATUS_PWM_INACTIVE                       0
#define INT_STATUS_PWM_ACTIVE                         1
#if 1   /* SM750 new definition (DMA0 is removed in SM750), therefore, the interrupt is
           moved to the DMA0 location.
         */
    #define INT_STATUS_DMA1                           9:9
    #define INT_STATUS_DMA1_INACTIVE                  0
    #define INT_STATUS_DMA1_ACTIVE                    1
#else
    #define INT_STATUS_DMA1                           10:10
    #define INT_STATUS_DMA1_INACTIVE                  0
    #define INT_STATUS_DMA1_ACTIVE                    1
    #define INT_STATUS_DMA0                           9:9
    #define INT_STATUS_DMA0_INACTIVE                  0
    #define INT_STATUS_DMA0_ACTIVE                    1
#endif
#define INT_STATUS_PCI                                8:8
#define INT_STATUS_PCI_INACTIVE                       0
#define INT_STATUS_PCI_ACTIVE                         1
#define INT_STATUS_SSP1                               7:7
#define INT_STATUS_SSP1_INACTIVE                      0
#define INT_STATUS_SSP1_ACTIVE                        1
#define INT_STATUS_SSP0                               6:6
#define INT_STATUS_SSP0_INACTIVE                      0
#define INT_STATUS_SSP0_ACTIVE                        1
#define INT_STATUS_DE                                 5:5
#define INT_STATUS_DE_INACTIVE                        0
#define INT_STATUS_DE_ACTIVE                          1
#define INT_STATUS_ZVPORT1_VSYNC                      4:4
#define INT_STATUS_ZVPORT1_VSYNC_INACTIVE             0
#define INT_STATUS_ZVPORT1_VSYNC_ACTIVE               1
#define INT_STATUS_ZVPORT0_VSYNC                      3:3
#define INT_STATUS_ZVPORT0_VSYNC_INACTIVE             0
#define INT_STATUS_ZVPORT0_VSYNC_ACTIVE               1
#define INT_STATUS_SECONDARY_VSYNC                    2:2
#define INT_STATUS_SECONDARY_VSYNC_INACTIVE           0
#define INT_STATUS_SECONDARY_VSYNC_ACTIVE             1
#define INT_STATUS_PRIMARY_VSYNC                      1:1
#define INT_STATUS_PRIMARY_VSYNC_INACTIVE             0
#define INT_STATUS_PRIMARY_VSYNC_ACTIVE               1
#define INT_STATUS_VGA_VSYNC                          0:0
#define INT_STATUS_VGA_VSYNC_INACTIVE                 0
#define INT_STATUS_VGA_VSYNC_ACTIVE                   1

#define INT_MASK                                      0x000028
#define INT_MASK_GPIO31                               31:31
#define INT_MASK_GPIO31_DISABLE                       0
#define INT_MASK_GPIO31_ENABLE                        1
#define INT_MASK_GPIO30                               30:30
#define INT_MASK_GPIO30_DISABLE                       0
#define INT_MASK_GPIO30_ENABLE                        1
#define INT_MASK_GPIO29                               29:29
#define INT_MASK_GPIO29_DISABLE                       0
#define INT_MASK_GPIO29_ENABLE                        1
#define INT_MASK_GPIO28                               28:28
#define INT_MASK_GPIO28_DISABLE                       0
#define INT_MASK_GPIO28_ENABLE                        1
#define INT_MASK_GPIO27                               27:27
#define INT_MASK_GPIO27_DISABLE                       0
#define INT_MASK_GPIO27_ENABLE                        1
#define INT_MASK_GPIO26                               26:26
#define INT_MASK_GPIO26_DISABLE                       0
#define INT_MASK_GPIO26_ENABLE                        1
#define INT_MASK_GPIO25                               25:25
#define INT_MASK_GPIO25_DISABLE                       0
#define INT_MASK_GPIO25_ENABLE                        1
#define INT_MASK_I2C                                  12:12
#define INT_MASK_I2C_DISABLE                          0
#define INT_MASK_I2C_ENABLE                           1
#define INT_MASK_PWM                                  11:11
#define INT_MASK_PWM_DISABLE                          0
#define INT_MASK_PWM_ENABLE                           1
#if 1   /* SM750 new definition (DMA0 is removed in SM750), therefore, the interrupt is
           moved to the DMA0 location.
         */
    #define INT_MASK_DMA1                             9:9
    #define INT_MASK_DMA1_DISABLE                     0
    #define INT_MASK_DMA1_ENABLE                      1
#else
    #define INT_MASK_DMA1                             10:10
    #define INT_MASK_DMA1_DISABLE                     0
    #define INT_MASK_DMA1_ENABLE                      1
    #define INT_MASK_DMA                              9:9
    #define INT_MASK_DMA_DISABLE                      0
    #define INT_MASK_DMA_ENABLE                       1
#endif
#define INT_MASK_PCI                                  8:8
#define INT_MASK_PCI_DISABLE                          0
#define INT_MASK_PCI_ENABLE                           1
#define INT_MASK_SSP1                                 7:7
#define INT_MASK_SSP1_DISABLE                         0
#define INT_MASK_SSP1_ENABLE                          1
#define INT_MASK_SSP0                                 6:6
#define INT_MASK_SSP0_DISABLE                         0
#define INT_MASK_SSP0_ENABLE                          1
#define INT_MASK_DE                                   5:5
#define INT_MASK_DE_DISABLE                           0
#define INT_MASK_DE_ENABLE                            1
#define INT_MASK_ZVPORT1_VSYNC                        4:4
#define INT_MASK_ZVPORT1_VSYNC_DISABLE                0
#define INT_MASK_ZVPORT1_VSYNC_ENABLE                 1
#define INT_MASK_ZVPORT0_VSYNC                        3:3
#define INT_MASK_ZVPORT0_VSYNC_DISABLE                0
#define INT_MASK_ZVPORT0_VSYNC_ENABLE                 1
#define INT_MASK_SECONDARY_VSYNC                      2:2
#define INT_MASK_SECONDARY_VSYNC_DISABLE              0
#define INT_MASK_SECONDARY_VSYNC_ENABLE               1
#define INT_MASK_PRIMARY_VSYNC                        1:1
#define INT_MASK_PRIMARY_VSYNC_DISABLE                0
#define INT_MASK_PRIMARY_VSYNC_ENABLE                 1
#define INT_MASK_VGA_VSYNC                            0:0
#define INT_MASK_VGA_VSYNC_DISABLE                    0
#define INT_MASK_VGA_VSYNC_ENABLE                     1

#define CURRENT_GATE                                  0x000040
#define CURRENT_GATE_MCLK                             15:14
#define CURRENT_GATE_MCLK_DIV_3                       0
#define CURRENT_GATE_MCLK_DIV_4                       1
#define CURRENT_GATE_MCLK_DIV_6                       2
#define CURRENT_GATE_MCLK_DIV_8                       3
#define CURRENT_GATE_M2XCLK                           13:12
#define CURRENT_GATE_M2XCLK_DIV_1                     0
#define CURRENT_GATE_M2XCLK_DIV_2                     1
#define CURRENT_GATE_M2XCLK_DIV_3                     2
#define CURRENT_GATE_M2XCLK_DIV_4                     3
#define CURRENT_GATE_VGA                              10:10
#define CURRENT_GATE_VGA_OFF                          0
#define CURRENT_GATE_VGA_ON                           1
#define CURRENT_GATE_PWM                              9:9
#define CURRENT_GATE_PWM_OFF                          0
#define CURRENT_GATE_PWM_ON                           1
#define CURRENT_GATE_I2C                              8:8
#define CURRENT_GATE_I2C_OFF                          0
#define CURRENT_GATE_I2C_ON                           1
#define CURRENT_GATE_SSP                              7:7
#define CURRENT_GATE_SSP_OFF                          0
#define CURRENT_GATE_SSP_ON                           1
#define CURRENT_GATE_GPIO                             6:6
#define CURRENT_GATE_GPIO_OFF                         0
#define CURRENT_GATE_GPIO_ON                          1
#define CURRENT_GATE_ZVPORT                           5:5
#define CURRENT_GATE_ZVPORT_OFF                       0
#define CURRENT_GATE_ZVPORT_ON                        1
#define CURRENT_GATE_CSC                              4:4
#define CURRENT_GATE_CSC_OFF                          0
#define CURRENT_GATE_CSC_ON                           1
#define CURRENT_GATE_DE                               3:3
#define CURRENT_GATE_DE_OFF                           0
#define CURRENT_GATE_DE_ON                            1
#define CURRENT_GATE_DISPLAY                          2:2
#define CURRENT_GATE_DISPLAY_OFF                      0
#define CURRENT_GATE_DISPLAY_ON                       1
#define CURRENT_GATE_LOCALMEM                         1:1
#define CURRENT_GATE_LOCALMEM_OFF                     0
#define CURRENT_GATE_LOCALMEM_ON                      1
#define CURRENT_GATE_DMA                              0:0
#define CURRENT_GATE_DMA_OFF                          0
#define CURRENT_GATE_DMA_ON                           1

#define MODE0_GATE                                    0x000044
#define MODE0_GATE_MCLK                               15:14
#define MODE0_GATE_MCLK_112MHZ                        0
#define MODE0_GATE_MCLK_84MHZ                         1
#define MODE0_GATE_MCLK_56MHZ                         2
#define MODE0_GATE_MCLK_42MHZ                         3
#define MODE0_GATE_M2XCLK                             13:12
#define MODE0_GATE_M2XCLK_336MHZ                      0
#define MODE0_GATE_M2XCLK_168MHZ                      1
#define MODE0_GATE_M2XCLK_112MHZ                      2
#define MODE0_GATE_M2XCLK_84MHZ                       3
#define MODE0_GATE_VGA                                10:10
#define MODE0_GATE_VGA_OFF                            0
#define MODE0_GATE_VGA_ON                             1
#define MODE0_GATE_PWM                                9:9
#define MODE0_GATE_PWM_OFF                            0
#define MODE0_GATE_PWM_ON                             1
#define MODE0_GATE_I2C                                8:8
#define MODE0_GATE_I2C_OFF                            0
#define MODE0_GATE_I2C_ON                             1
#define MODE0_GATE_SSP                                7:7
#define MODE0_GATE_SSP_OFF                            0
#define MODE0_GATE_SSP_ON                             1
#define MODE0_GATE_GPIO                               6:6
#define MODE0_GATE_GPIO_OFF                           0
#define MODE0_GATE_GPIO_ON                            1
#define MODE0_GATE_ZVPORT                             5:5
#define MODE0_GATE_ZVPORT_OFF                         0
#define MODE0_GATE_ZVPORT_ON                          1
#define MODE0_GATE_CSC                                4:4
#define MODE0_GATE_CSC_OFF                            0
#define MODE0_GATE_CSC_ON                             1
#define MODE0_GATE_DE                                 3:3
#define MODE0_GATE_DE_OFF                             0
#define MODE0_GATE_DE_ON                              1
#define MODE0_GATE_DISPLAY                            2:2
#define MODE0_GATE_DISPLAY_OFF                        0
#define MODE0_GATE_DISPLAY_ON                         1
#define MODE0_GATE_LOCALMEM                           1:1
#define MODE0_GATE_LOCALMEM_OFF                       0
#define MODE0_GATE_LOCALMEM_ON                        1
#define MODE0_GATE_DMA                                0:0
#define MODE0_GATE_DMA_OFF                            0
#define MODE0_GATE_DMA_ON                             1

#define MODE1_GATE                                    0x000048
#define MODE1_GATE_MCLK                               15:14
#define MODE1_GATE_MCLK_112MHZ                        0
#define MODE1_GATE_MCLK_84MHZ                         1
#define MODE1_GATE_MCLK_56MHZ                         2
#define MODE1_GATE_MCLK_42MHZ                         3
#define MODE1_GATE_M2XCLK                             13:12
#define MODE1_GATE_M2XCLK_336MHZ                      0
#define MODE1_GATE_M2XCLK_168MHZ                      1
#define MODE1_GATE_M2XCLK_112MHZ                      2
#define MODE1_GATE_M2XCLK_84MHZ                       3
#define MODE1_GATE_VGA                                10:10
#define MODE1_GATE_VGA_OFF                            0
#define MODE1_GATE_VGA_ON                             1
#define MODE1_GATE_PWM                                9:9
#define MODE1_GATE_PWM_OFF                            0
#define MODE1_GATE_PWM_ON                             1
#define MODE1_GATE_I2C                                8:8
#define MODE1_GATE_I2C_OFF                            0
#define MODE1_GATE_I2C_ON                             1
#define MODE1_GATE_SSP                                7:7
#define MODE1_GATE_SSP_OFF                            0
#define MODE1_GATE_SSP_ON                             1
#define MODE1_GATE_GPIO                               6:6
#define MODE1_GATE_GPIO_OFF                           0
#define MODE1_GATE_GPIO_ON                            1
#define MODE1_GATE_ZVPORT                             5:5
#define MODE1_GATE_ZVPORT_OFF                         0
#define MODE1_GATE_ZVPORT_ON                          1
#define MODE1_GATE_CSC                                4:4
#define MODE1_GATE_CSC_OFF                            0
#define MODE1_GATE_CSC_ON                             1
#define MODE1_GATE_DE                                 3:3
#define MODE1_GATE_DE_OFF                             0
#define MODE1_GATE_DE_ON                              1
#define MODE1_GATE_DISPLAY                            2:2
#define MODE1_GATE_DISPLAY_OFF                        0
#define MODE1_GATE_DISPLAY_ON                         1
#define MODE1_GATE_LOCALMEM                           1:1
#define MODE1_GATE_LOCALMEM_OFF                       0
#define MODE1_GATE_LOCALMEM_ON                        1
#define MODE1_GATE_DMA                                0:0
#define MODE1_GATE_DMA_OFF                            0
#define MODE1_GATE_DMA_ON                             1

#define POWER_MODE_CTRL                               0x00004C
#define POWER_MODE_CTRL_OSC_INPUT                     3:3
#define POWER_MODE_CTRL_OSC_INPUT_OFF                 0
#define POWER_MODE_CTRL_OSC_INPUT_ON                  1
#define POWER_MODE_CTRL_ACPI                          2:2
#define POWER_MODE_CTRL_ACPI_OFF                      0
#define POWER_MODE_CTRL_ACPI_ON                       1
#define POWER_MODE_CTRL_MODE                          1:0
#define POWER_MODE_CTRL_MODE_MODE0                    0
#define POWER_MODE_CTRL_MODE_MODE1                    1
#define POWER_MODE_CTRL_MODE_SLEEP                    2

/* This definition is for SM750 */
#define PCI_MASTER_BASE                               0x000050
#define PCI_MASTER_BASE_ADDRESS                       7:0

/* This definition is for SM718 */
#define SM718_PCI_MASTER_BASE                         0x000050
#define SM718_PCI_MASTER_BASE_ADDRESS                 31:20

#define DEVICE_ID                                     0x000054
#define DEVICE_ID_DEVICE_ID                           31:16
#define DEVICE_ID_REVISION_ID                         7:0

#define PLL_CLK_COUNT                                 0x000058
#define PLL_CLK_COUNT_COUNTER                         15:0

#define PRIMARY_PLL_CTRL                              0x00005C
#define PRIMARY_PLL_CTRL_BYPASS                       18:18
#define PRIMARY_PLL_CTRL_BYPASS_OFF                   0
#define PRIMARY_PLL_CTRL_BYPASS_ON                    1
#define PRIMARY_PLL_CTRL_POWER                        17:17
#define PRIMARY_PLL_CTRL_POWER_OFF                    0
#define PRIMARY_PLL_CTRL_POWER_ON                     1
#define PRIMARY_PLL_CTRL_INPUT                        16:16
#define PRIMARY_PLL_CTRL_INPUT_OSC                    0
#define PRIMARY_PLL_CTRL_INPUT_TESTCLK                1
#define PRIMARY_PLL_CTRL_POD                          15:14
#define PRIMARY_PLL_CTRL_OD                           13:12
#define PRIMARY_PLL_CTRL_N                            11:8
#define PRIMARY_PLL_CTRL_M                            7:0

#define SECONDARY_PLL_CTRL                            0x000060
#define SECONDARY_PLL_CTRL_BYPASS                     18:18
#define SECONDARY_PLL_CTRL_BYPASS_OFF                 0
#define SECONDARY_PLL_CTRL_BYPASS_ON                  1
#define SECONDARY_PLL_CTRL_POWER                      17:17
#define SECONDARY_PLL_CTRL_POWER_OFF                  0
#define SECONDARY_PLL_CTRL_POWER_ON                   1
#define SECONDARY_PLL_CTRL_INPUT                      16:16
#define SECONDARY_PLL_CTRL_INPUT_OSC                  0
#define SECONDARY_PLL_CTRL_INPUT_TESTCLK              1
#define SECONDARY_PLL_CTRL_POD                        15:14
#define SECONDARY_PLL_CTRL_OD                         13:12    
#define SECONDARY_PLL_CTRL_N                          11:8
#define SECONDARY_PLL_CTRL_M                          7:0

#define VGA_PLL0_CTRL                                 0x000064
#define VGA_PLL0_CTRL_BYPASS                          18:18
#define VGA_PLL0_CTRL_BYPASS_OFF                      0
#define VGA_PLL0_CTRL_BYPASS_ON                       1
#define VGA_PLL0_CTRL_POWER                           17:17
#define VGA_PLL0_CTRL_POWER_OFF                       0
#define VGA_PLL0_CTRL_POWER_ON                        1
#define VGA_PLL0_CTRL_INPUT                           16:16
#define VGA_PLL0_CTRL_INPUT_OSC                       0
#define VGA_PLL0_CTRL_INPUT_TESTCLK                   1
#define VGA_PLL0_CTRL_POD                             15:14
#define VGA_PLL0_CTRL_OD                              13:12
#define VGA_PLL0_CTRL_N                               11:8
#define VGA_PLL0_CTRL_M                               7:0

#define VGA_PLL1_CTRL                                 0x000068
#define VGA_PLL1_CTRL_BYPASS                          18:18
#define VGA_PLL1_CTRL_BYPASS_OFF                      0
#define VGA_PLL1_CTRL_BYPASS_ON                       1
#define VGA_PLL1_CTRL_POWER                           17:17
#define VGA_PLL1_CTRL_POWER_OFF                       0
#define VGA_PLL1_CTRL_POWER_ON                        1
#define VGA_PLL1_CTRL_INPUT                           16:16
#define VGA_PLL1_CTRL_INPUT_OSC                       0
#define VGA_PLL1_CTRL_INPUT_TESTCLK                   1
#define VGA_PLL1_CTRL_POD                             15:14
#define VGA_PLL1_CTRL_OD                              13:12
#define VGA_PLL1_CTRL_N                               11:8
#define VGA_PLL1_CTRL_M                               7:0
#define VGA_PLL1_MASK                                 0x00FFFFFF

/* Use peekRegisterByte to access this scratch data */
#define SCRATCH_DATA                                  0x00006b
/* The following register is used by HW */
/*#define SCRATCH_DATA                                  0x00006c*/

#define MXCLK_PLL_CTRL                                0x000070
#define MXCLK_PLL_CTRL_BYPASS                         18:18
#define MXCLK_PLL_CTRL_BYPASS_OFF                     0
#define MXCLK_PLL_CTRL_BYPASS_ON                      1
#define MXCLK_PLL_CTRL_POWER                          17:17
#define MXCLK_PLL_CTRL_POWER_OFF                      0
#define MXCLK_PLL_CTRL_POWER_ON                       1
#define MXCLK_PLL_CTRL_INPUT                          16:16
#define MXCLK_PLL_CTRL_INPUT_OSC                      0
#define MXCLK_PLL_CTRL_INPUT_TESTCLK                  1
#define MXCLK_PLL_CTRL_POD                            15:14
#define MXCLK_PLL_CTRL_OD                             13:12
#define MXCLK_PLL_CTRL_N                              11:8
#define MXCLK_PLL_CTRL_M                              7:0

/* Host Interface registers support. Only applies to SM718 */
#define HOST_INTERFACE                                0x000074
#define HOST_INTERFACE_NON_CACHE_ADDRESS              30:17
/* The following status is read-only. 
   When SM718 is transitioning back from sleep mode to normal mode, software needs 
   to poll this bit until it becomes "0" before writing any other command to the chip. */
#define HOST_INTERFACE_STATUS                         16:16
#define HOST_INTERFACE_STATUS_NORMAL                  0
#define HOST_INTERFACE_STATUS_SLEEP                   1
#define HOST_INTERFACE_CPU                            15:15
#define HOST_INTERFACE_CPU_32BIT                      0
#define HOST_INTERFACE_CPU_16BIT                      1
#define HOST_INTERFACE_XSCALE_INPUT_SOURCE            14:14
#define HOST_INTERFACE_XSCALE_INPUT_SOURCE_PLL        0
#define HOST_INTERFACE_XSCALE_INPUT_SOURCE_HCLK       1
#define HOST_INTERFACE_ENDIAN                         7:7
#define HOST_INTERFACE_ENDIAN_LITTLE                  0
#define HOST_INTERFACE_ENDIAN_BIG                     1
/* The following polarity is determined by GPIO20 pin at reset */
#define HOST_INTERFACE_HITACHI_POLARITY               6:6
#define HOST_INTERFACE_HITACHI_POLARITY_ACTIVE_LOW    0
#define HOST_INTERFACE_HITACHI_POLARITY_ACTIVE_HIGH   1
#define HOST_INTERFACE_NEC_MEMORY_MAP_LOCATION        5:5
#define HOST_INTERFACE_NEC_MEMORY_MAP_LOCATION_30MB   0
#define HOST_INTERFACE_NEC_MEMORY_MAP_LOCATION_62MB   1
#define HOST_INTERFACE_SH4_READY                      4:3
#define HOST_INTERFACE_SH4_READY_ONE_CLOCK            0
#define HOST_INTERFACE_SH4_READY_TWO_CLOCKS           1
#define HOST_INTERFACE_SH4_READY_CS_CONTROL           2
/* The following bus type is determined by GPIO19, GPIO18, and GPIO17 pins at reset */
#define HOST_INTERFACE_BUS_TYPE                       2:0
#define HOST_INTERFACE_BUS_TYPE_HITACHI_SH3_SH4       0
#define HOST_INTERFACE_BUS_TYPE_PCI                   1
#define HOST_INTERFACE_BUS_TYPE_INTEL_XSCALE          2
#define HOST_INTERFACE_BUS_TYPE_NEC                   6

/* System memory register. Only applies to SM718 */
#define SYSTEM_MEMORY                                 0x000078
/* Extend the bus holding when SM718 is a host bust master to access system SDRAM. */
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT            23:20
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_0          0
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_16         1
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_32         2
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_48         3
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_64         4
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_80         5
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_96         6
#define SYSTEM_MEMORY_HOST_BUS_HOLDING_EXT_112        7
#define SYSTEM_MEMORY_BURST_LENGTH                    19:17
#define SYSTEM_MEMORY_BURST_LENGTH_1_WORD             0
#define SYSTEM_MEMORY_BURST_LENGTH_2_WORDS            1
#define SYSTEM_MEMORY_BURST_LENGTH_4_WORDS            2
#define SYSTEM_MEMORY_BURST_LENGTH_8_WORDS            3
#define SYSTEM_MEMORY_CAS_LATENCY                     16:16
#define SYSTEM_MEMORY_CAS_LATENCY_2_CLOCKS            0
#define SYSTEM_MEMORY_CAS_LATENCY_3_CLOCKS            1
#define SYSTEM_MEMORY_BUS_HOLD_TIME                   15:13
#define SYSTEM_MEMORY_BUS_HOLD_TIME_FIFO_EMPTY        0
#define SYSTEM_MEMORY_BUS_HOLD_TIME_8_TRANSACTIONS    1
#define SYSTEM_MEMORY_BUS_HOLD_TIME_16_TRANSACTIONS   2
#define SYSTEM_MEMORY_BUS_HOLD_TIME_24_TRANSACTIONS   3
#define SYSTEM_MEMORY_BUS_HOLD_TIME_32_TRANSACTIONS   4
#define SYSTEM_MEMORY_COLUMN_SIZE                     12:11
#define SYSTEM_MEMORY_COLUMN_SIZE_1024_WORDS          0
#define SYSTEM_MEMORY_COLUMN_SIZE_512_WORDS           2
#define SYSTEM_MEMORY_COLUMN_SIZE_256_WORDS           3
#define SYSTEM_MEMORY_SIZE                            10:8
#define SYSTEM_MEMORY_SIZE_2MB                        0
#define SYSTEM_MEMORY_SIZE_4MB                        1
#define SYSTEM_MEMORY_SIZE_64MB                       4
#define SYSTEM_MEMORY_SIZE_32MB                       5
#define SYSTEM_MEMORY_SIZE_16MB                       6
#define SYSTEM_MEMORY_SIZE_8MB                        7
/* System Memory Active to Pre-charge delay */
#define SYSTEM_MEMORY_ACTIVE_DELAY                    7:7
#define SYSTEM_MEMORY_ACTIVE_DELAY_6_CLOCKS           0
#define SYSTEM_MEMORY_ACTIVE_DELAY_7_CLOCKS           1
/* System Memory Write to Pre-charge delay */
#define SYSTEM_MEMORY_WRITE_DELAY                     6:6
#define SYSTEM_MEMORY_WRITE_DELAY_2_CLOCKS            0
#define SYSTEM_MEMORY_WRITE_DELAY_1_CLOCK             1
#define SYSTEM_MEMORY_BANK                            5:5
#define SYSTEM_MEMORY_BANK_4                          0
#define SYSTEM_MEMORY_BANK_2                          1
#define SYSTEM_MEMORY_RESET                           4:4
#define SYSTEM_MEMORY_RESET_ENABLE                    0
#define SYSTEM_MEMORY_RESET_DISABLE                   1
/* Delay time to latch read data for external SDRAM controller (in 1/2 ns step) */
#define SYSTEM_MEMORY_LATCH_DELAY                     3:1
#define SYSTEM_MEMORY_LATCH_DELAY_0                   0
#define SYSTEM_MEMORY_LATCH_DELAY_1                   1
#define SYSTEM_MEMORY_LATCH_DELAY_2                   2
#define SYSTEM_MEMORY_LATCH_DELAY_3                   3
#define SYSTEM_MEMORY_LATCH_DELAY_4                   4
#define SYSTEM_MEMORY_LATCH_DELAY_5                   5
#define SYSTEM_MEMORY_CPU_MASTER_BURST_LENGTH         0:0
#define SYSTEM_MEMORY_CPU_MASTER_BURST_LENGTH_8       0
#define SYSTEM_MEMORY_CPU_MASTER_BURST_LENGTH_1       1

#define VGA_CONFIGURATION                             0x000088
#define	VGA_CONFIGURATION_A0000_ACCESS				  7:7
#define VGA_CONFIGURATION_A0000_ACCESS_DISABLE        0
#define VGA_CONFIGURATION_A0000_ACCESS_ENABLE         1
#define VGA_CONFIGURATION_USER_DEFINE                 5:4
#define VGA_CONFIGURATION_PLL                         2:2
#define VGA_CONFIGURATION_PLL_VGA                     0
#define VGA_CONFIGURATION_PLL_PRIMARY                 1
#define VGA_CONFIGURATION_MODE                        1:1
#define VGA_CONFIGURATION_MODE_TEXT                   0
#define VGA_CONFIGURATION_MODE_GRAPHIC                1
/* The following only applies to SM718 (Strap pin MA Line 11) */
#define VGA_CONFIGURATION_C0000_ACCESS                0:0
#define VGA_CONFIGURATION_C0000_ACCESS_DISABLE        0
#define VGA_CONFIGURATION_C0000_ACCESS_ENABLE         1
