# Summary

[Introduction](./introduction.md)

--------------------------------------------------------------------------------

- [Examples](./examples/index.md)
  - [Hello, World!](./examples/hello-world.md)
  - [Using `console.log`](./examples/console-log.md)
  - [Small wasm files](./examples/add.md)
  - [Without a Bundler](./examples/without-a-bundler.md)
  - [Converting WebAssembly to JS](./examples/wasm2js.md)
  - [Importing functions from JS](./examples/import-js.md)
  - [Working with `char`](./examples/char.md)
  - [js-sys: WebAssembly in WebAssembly](./examples/wasm-in-wasm.md)
  - [web-sys: DOM hello world](./examples/dom.md)
  - [web-sys: Closures](./examples/closures.md)
  - [web-sys: `performance.now`](./examples/performance.md)
  - [web-sys: using `fetch`](./examples/fetch.md)
  - [web-sys: `canvas` hello world](./examples/2d-canvas.md)
  - [web-sys: `canvas` Julia set](./examples/julia.md)
  - [web-sys: WebAudio](./examples/web-audio.md)
  - [web-sys: WebGL](./examples/webgl.md)
  - [web-sys: WebSockets](./examples/websockets.md)
  - [web-sys: WebRTC DataChannel](./examples/webrtc_datachannel.md)
  - [web-sys: `requestAnimationFrame`](./examples/request-animation-frame.md)
  - [web-sys: A Simple Paint Program](./examples/paint.md)
  - [web-sys: WASM in Web Worker](./examples/wasm-in-web-worker.md)
  - [Parallel Raytracing](./examples/raytrace.md)
  - [WASM Audio Worklet](./examples/wasm-audio-worklet.md)
  - [web-sys: A TODO MVC App](./examples/todomvc.md)
- [Reference](./reference/index.md)
  - [Deployment](./reference/deployment.md)
  - [JS snippets](./reference/js-snippets.md)
  - [Passing Rust Closures to JS](./reference/passing-rust-closures-to-js.md)
  - [Receiving JS Closures in Rust](./reference/receiving-js-closures-in-rust.md)
  - [`Promise`s and `Future`s](./reference/js-promises-and-rust-futures.md)
  - [Iterating over JS Values](./reference/iterating-over-js-values.md)
  - [Arbitrary Data with Serde](./reference/arbitrary-data-with-serde.md)
  - [Accessing Properties of Untyped JS Values](./reference/accessing-properties-of-untyped-js-values.md)
  - [Working with Duck-Typed Interfaces](./reference/working-with-duck-typed-interfaces.md)
  - [Command Line Interface](./reference/cli.md)
  - [Optimizing for Size](./reference/optimize-size.md)
  - [Supported Rust Targets](./reference/rust-targets.md)
  - [Supported Browsers](./reference/browser-support.md)
  - [Support for Weak References](./reference/weak-references.md)
  - [Support for Reference Types](./reference/reference-types.md)
  - [Supported Types](./reference/types.md)
    - [Imported JavaScript Types](./reference/types/imported-js-types.md)
    - [Exported Rust Types](./reference/types/exported-rust-types.md)
    - [`JsValue`](./reference/types/jsvalue.md)
    - [`Box<[JsValue]>`](./reference/types/boxed-jsvalue-slice.md)
    - [`*const T` and `*mut T`](./reference/types/pointers.md)
    - [Numbers](./reference/types/numbers.md)
    - [`bool`](./reference/types/bool.md)
    - [`char`](./reference/types/char.md)
    - [`str`](./reference/types/str.md)
    - [`String`](./reference/types/string.md)
    - [Number Slices](./reference/types/number-slices.md)
    - [Boxed Number Slices](./reference/types/boxed-number-slices.md)
    - [`Result<T, E>`](./reference/types/result.md)
  - [`#[wasm_bindgen]` Attributes](./reference/attributes/index.md)
    - [On JavaScript Imports](./reference/attributes/on-js-imports/index.md)
      - [`catch`](./reference/attributes/on-js-imports/catch.md)
      - [`constructor`](./reference/attributes/on-js-imports/constructor.md)
      - [`extends`](./reference/attributes/on-js-imports/extends.md)
      - [`getter` and `setter`](./reference/attributes/on-js-imports/getter-and-setter.md)
      - [`final`](./reference/attributes/on-js-imports/final.md)
      - [`indexing_getter`, `indexing_setter`, and `indexing_deleter`](./reference/attributes/on-js-imports/indexing-getter-setter-deleter.md)
      - [`js_class = "Blah"`](./reference/attributes/on-js-imports/js_class.md)
      - [`js_name`](./reference/attributes/on-js-imports/js_name.md)
      - [`js_namespace`](./reference/attributes/on-js-imports/js_namespace.md)
      - [`method`](./reference/attributes/on-js-imports/method.md)
      - [`module = "blah"`](./reference/attributes/on-js-imports/module.md)
      - [`raw_module = "blah"`](./reference/attributes/on-js-imports/raw_module.md)
      - [`static_method_of = Blah`](./reference/attributes/on-js-imports/static_method_of.md)
      - [`structural`](./reference/attributes/on-js-imports/structural.md)
      - [`variadic`](./reference/attributes/on-js-imports/variadic.md)
      - [`vendor_prefix`](./reference/attributes/on-js-imports/vendor_prefix.md)
    - [On Rust Exports](./reference/attributes/on-rust-exports/index.md)
      - [`constructor`](./reference/attributes/on-rust-exports/constructor.md)
      - [`js_name = Blah`](./reference/attributes/on-rust-exports/js_name.md)
      - [`readonly`](./reference/attributes/on-rust-exports/readonly.md)
      - [`skip`](./reference/attributes/on-rust-exports/skip.md)
      - [`start`](./reference/attributes/on-rust-exports/start.md)
      - [`typescript_custom_section`](./reference/attributes/on-rust-exports/typescript_custom_section.md)
      - [`getter` and `setter`](./reference/attributes/on-rust-exports/getter-and-setter.md)
      - [`inspectable`](./reference/attributes/on-rust-exports/inspectable.md)
      - [`skip_typescript`](./reference/attributes/on-rust-exports/skip_typescript.md)
      - [`typescript_type`](./reference/attributes/on-rust-exports/typescript_type.md)
      - [`getter_with_clone`](./reference/attributes/on-rust-exports/getter_with_clone.md)

- [`web-sys`](./web-sys/index.md)
  - [Using `web-sys`](./web-sys/using-web-sys.md)
  - [Cargo Features](./web-sys/cargo-features.md)
  - [Function Overloads](./web-sys/function-overloads.md)
  - [Type Translations](./web-sys/type-translations.md)
  - [Inheritance](./web-sys/inheritance.md)
  - [Unstable APIs](./web-sys/unstable-apis.md)

- [Testing with `wasm-bindgen-test`](./wasm-bindgen-test/index.md)
  - [Usage](./wasm-bindgen-test/usage.md)
  - [Writing Asynchronous Tests](./wasm-bindgen-test/asynchronous-tests.md)
  - [Testing in Headless Browsers](./wasm-bindgen-test/browsers.md)
  - [Continuous Integration](./wasm-bindgen-test/continuous-integration.md)

- [Contributing to `wasm-bindgen`](./contributing/index.md)
  - [Testing](./contributing/testing.md)
  - [Internal Design](./contributing/design/index.md)
    - [JS Objects in Rust](./contributing/design/js-objects-in-rust.md)
    - [Exporting a function to JS](./contributing/design/exporting-rust.md)
    - [Exporting a struct to JS](./contributing/design/exporting-rust-struct.md)
    - [Importing a function from JS](./contributing/design/importing-js.md)
    - [Importing a class from JS](./contributing/design/importing-js-struct.md)
    - [Rust Type conversions](./contributing/design/rust-type-conversions.md)
    - [Types in `wasm-bindgen`](./contributing/design/describe.md)
  - [`js-sys`](./contributing/js-sys/index.md)
    - [Testing](./contributing/js-sys/testing.md)
    - [Adding More APIs](./contributing/js-sys/adding-more-apis.md)
  - [`web-sys`](./contributing/web-sys/index.md)
    - [Overview](./contributing/web-sys/overview.md)
    - [Testing](./contributing/web-sys/testing.md)
    - [Logging](./contributing/web-sys/logging.md)
    - [Supporting More Web APIs](./contributing/web-sys/supporting-more-web-apis.md)
  - [Publishing](./contributing/publishing.md)
  - [Team](./contributing/team.md)
