/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Direction {
    #[serde(rename = "DEPART")]
    Depart,
    #[serde(rename = "HARD_LEFT")]
    HardLeft,
    #[serde(rename = "LEFT")]
    Left,
    #[serde(rename = "SLIGHTLY_LEFT")]
    SlightlyLeft,
    #[serde(rename = "CONTINUE")]
    Continue,
    #[serde(rename = "SLIGHTLY_RIGHT")]
    SlightlyRight,
    #[serde(rename = "RIGHT")]
    Right,
    #[serde(rename = "HARD_RIGHT")]
    HardRight,
    #[serde(rename = "CIRCLE_CLOCKWISE")]
    CircleClockwise,
    #[serde(rename = "CIRCLE_COUNTERCLOCKWISE")]
    CircleCounterclockwise,
    #[serde(rename = "STAIRS")]
    Stairs,
    #[serde(rename = "ELEVATOR")]
    Elevator,
    #[serde(rename = "UTURN_LEFT")]
    UturnLeft,
    #[serde(rename = "UTURN_RIGHT")]
    UturnRight,

}

impl std::fmt::Display for Direction {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::Depart => write!(f, "DEPART"),
            Self::HardLeft => write!(f, "HARD_LEFT"),
            Self::Left => write!(f, "LEFT"),
            Self::SlightlyLeft => write!(f, "SLIGHTLY_LEFT"),
            Self::Continue => write!(f, "CONTINUE"),
            Self::SlightlyRight => write!(f, "SLIGHTLY_RIGHT"),
            Self::Right => write!(f, "RIGHT"),
            Self::HardRight => write!(f, "HARD_RIGHT"),
            Self::CircleClockwise => write!(f, "CIRCLE_CLOCKWISE"),
            Self::CircleCounterclockwise => write!(f, "CIRCLE_COUNTERCLOCKWISE"),
            Self::Stairs => write!(f, "STAIRS"),
            Self::Elevator => write!(f, "ELEVATOR"),
            Self::UturnLeft => write!(f, "UTURN_LEFT"),
            Self::UturnRight => write!(f, "UTURN_RIGHT"),
        }
    }
}

impl Default for Direction {
    fn default() -> Direction {
        Self::Depart
    }
}

