# Code of Conduct

## When Something Happens

If you see behavoir that makes you feel unsafe or unwelcome or otherwise uncomfortable, follow these steps:

1. Let the person know that what they did is not appropriate and ask them to stop and/or edit their message(s) or commits.
2. That person should immediately stop the behavior and correct the issue.
3. If this doesn’t happen, or if you're uncomfortable speaking up, [contact the maintainers](#contacting-maintainers).
4. As soon as available, a maintainer will look into the issue, and take [further action (see below)](#further-enforcement), starting with a warning, then temporary block, then long-term repo or organization ban.

**The maintainer team will prioritize the well-being and comfort of those affected over the comfort of the offending party.** See [some examples below](#enforcement-examples).

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers of this project pledge to making participation in our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, technical preferences, nationality, personal appearance, race, religion, or sexual identity and orientation.

This commitment means that inappropriate behavior can lead to intervention. This includes our intention to address issues with [missing stairs](https://en.wikipedia.org/wiki/Missing_stair) who may not have explicitly violated any written-down rules but might still be disrupting the community.

## Scope

This Code of Conduct applies both within spaces involving this project and in other spaces involving community members. This includes the repository, its Pull Requests and Issue tracker, its Twitter community, private email communications in the context of the project, and any events where members of the project are participating, as well as adjacent communities and venues affecting the project's members.

Depending on the violation, the maintainers may decide that violations of this code of conduct that have happened outside of the scope of the community may deem an individual unwelcome, and take appropriate action to maintain the comfort and safety of its members.

## Contacting Maintainers

- [Dan Smith <danini@hey.com>](mailto:danini@hey.com)

## Further Enforcement

If you've already followed the [initial enforcement steps](#enforcement), these are the steps maintainers will take for further enforcement, as needed:

  1. Repeat the request to stop.
  2. If the person doubles down, they will have offending messages removed or edited by a maintainers given an official warning. The PR or Issue may be locked.
  3. If the behavior continues or is repeated later, the person will be blocked from participating for 24 hours.
  4. If the behavior continues or is repeated after the temporary block, a long-term (6-12mo) ban will be used.

On top of this, maintainers may remove any offending messages, images, contributions, etc, as they deem necessary.

Maintainers reserve full rights to skip any of these steps, at their discretion, if the violation is considered to be a serious and/or immediate threat to the health and well-being of members of the community. These include any threats, serious physical or verbal attacks, and other such behavior that would be completely unacceptable in any social setting that puts our members at risk.

Members expelled from events or venues with any sort of paid attendance will not be refunded.

## Who Watches the Watchers?

Maintainers and other leaders who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership. These may include anything from removal from the maintainer team to a permanent ban from the community.

Additionally, as a project hosted on both GitHub, [their Community Guidielines may be applied to maintainers of this project](https://help.github.com/articles/github-community-guidelines/), externally of this project's procedures.

## Enforcement Examples

### The Best Case

The vast majority of situations work out like this. This interaction is common, and generally positive.

> Alex: "Yeah I used X and it was really crazy!"

> Patt (not a maintainer): "Hey, could you not use that word? What about 'ridiculous' instead?"

> Alex: "oh sorry, sure." -> edits old comment to say "it was really confusing!"

### The Maintainer Case

Sometimes, though, you need to get maintainers involved. Maintainers will do their best to resolve conflicts, but people who were harmed by something **will take priority**.

> Patt: "Honestly, sometimes I just really hate using $library and anyone who uses it probably sucks at their job."

> Alex: "Whoa there, could you dial it back a bit? There's a CoC thing about attacking folks' tech use like that."

> Patt: "I'm not attacking anyone, what's your problem?"

> Alex: "@maintainers hey uh. Can someone look at this issue? Patt is getting a bit aggro. I tried to nudge them about it, but nope."

> KeeperOfCommitBits: (on issue) "Hey Patt, maintainer here. Could you tone it down? This sort of attack is really not okay in this space."

> Patt: "Leave me alone I haven't said anything bad wtf is wrong with you."

> KeeperOfCommitBits: (deletes user's comment), "@patt I mean it. Please refer to the CoC over at (URL to this CoC) if you have questions, but you can consider this an actual warning. I'd appreciate it if you reworded your messages in this thread, since they made folks there uncomfortable. Let's try and be kind, yeah?"

> Patt: "@keeperofbits Okay sorry. I'm just frustrated and I'm kinda burnt out and I guess I got carried away. I'll DM Alex a note apologizing and edit my messages. Sorry for the trouble."

> KeeperOfCommitBits: "@patt Thanks for that. I hear you on the stress. Burnout sucks :/.  Have a good one!"

### The Nope Case

> PepeTheFrog🐸: "Hi, I am a literal actual nazi and I think white supremacists are quite fashionable."

> Patt: "NOOOOPE. OH NOPE NOPE."

> Alex: "JFC NO. NOPE. @keeperofbits NOPE NOPE LOOK HERE"

> KeeperOfCommitBits: "👀 Nope. NOPE NOPE NOPE. 🔥"

> PepeTheFrog🐸 has been banned from all organization or user repositories belonging to KeeperOfCommitBits.

## Attribution

This Code of Conduct was generated using [WeAllJS Code of Conduct Generator](https://npm.im/weallbehave), which is based on the [WeAllJS Code of
Conduct](https://wealljs.org/code-of-conduct), which is itself based on
[Contributor Covenant](http://contributor-covenant.org), version 1.4, available
at
[http://contributor-covenant.org/version/1/4](http://contributor-covenant.org/version/1/4),
and the LGBTQ in Technology Slack [Code of
Conduct](http://lgbtq.technology/coc.html).
