// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from WlanLog.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.logging {
  public class WlanLog : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("logging.WlanLog:1.0.0", null);

    public WlanLog(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public WlanLog(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new WlanLog StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new WlanLog(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class ClearResult {
    }

    public ClearResult clear() {
      JsonObject _parameters = null;
      var _result = RpcCall("clear", _parameters);
      var _ret = new ClearResult();
      return _ret;
    }

    public AsyncRequest clear(AsyncRpcResponse<ClearResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return clear(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest clear(AsyncRpcResponse<ClearResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("clear", _parameters,
        _result => {
          try {
            var _ret = new ClearResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.logging.LogInfo _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.logging.LogInfo.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.logging.LogInfo.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetChunkResult {
      public Com.Raritan.Idl.logging.LogChunk _ret_;
    }

    public GetChunkResult getChunk(int refId, int count, Com.Raritan.Idl.logging.RangeDirection direction) {
      var _parameters = new LightJson.JsonObject();
      _parameters["refId"] = refId;
      _parameters["count"] = count;
      _parameters["direction"] = (int)direction;

      var _result = RpcCall("getChunk", _parameters);
      var _ret = new GetChunkResult();
      _ret._ret_ = Com.Raritan.Idl.logging.LogChunk.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getChunk(int refId, int count, Com.Raritan.Idl.logging.RangeDirection direction, AsyncRpcResponse<GetChunkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getChunk(refId, count, direction, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getChunk(int refId, int count, Com.Raritan.Idl.logging.RangeDirection direction, AsyncRpcResponse<GetChunkResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["refId"] = refId;
        _parameters["count"] = count;
        _parameters["direction"] = (int)direction;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getChunk", _parameters,
        _result => {
          try {
            var _ret = new GetChunkResult();
            _ret._ret_ = Com.Raritan.Idl.logging.LogChunk.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
