% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflate.R
\name{deflate}
\alias{deflate}
\title{Compress a raw GZIP stream}
\usage{
deflate(buffer, level = 6L, pos = 1L, size = NULL)
}
\arguments{
\item{buffer}{Raw vector, containing the data to compress.}

\item{level}{Compression level, integer between 1 (fatest) and 9 (best).}

\item{pos}{Start position of data to compress in \code{buffer}.}

\item{size}{Compressed size estimate, or \code{NULL}. If not given, or too
small, the output buffer is resized multiple times.}
}
\value{
Named list with three entries:
\itemize{
\item \code{output}: raw vector, the compressed data,
\item \code{bytes_read}: number of bytes used from \code{buffer},
\item \code{bytes_written}: number of bytes written to the output buffer.
}
}
\description{
Compress a raw GZIP stream
}
\examples{
data_gz <- deflate(charToRaw("Hello world!"))
inflate(data_gz$output)
}
\seealso{
\code{\link[base:memCompress]{base::memCompress()}} does the same with \code{type = "gzip"},
but it does not tell you the number of bytes read from the input.
}
