% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_qid}
\alias{as_qid}
\title{Convert an input to a item QID}
\usage{
as_qid(x)
}
\arguments{
\item{x}{a vector, data frame, or tibble of strings representaing wikidata items}
}
\value{
if the inputted string is a valid QID, return the string.
If the inputted string matches an item label, return its QID.
If the inputted string matches multiple labels of multiple items, return the QID of the first hit.
}
\description{
Convert an input string to the most likely item QID
}
\examples{
# if input string is a valid QID
as_qid("Q42")
# if input string matches multiple item labels
as_qid("Douglas Adams")
# if input string matches a single unique label
as_qid("Douglas Adams and the question of arterial blood pressure in mammals")
}
