% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_names.R, R/methods.R
\name{ott_id.match_names}
\alias{ott_id.match_names}
\alias{flags.match_names}
\alias{flags}
\title{\code{ott_id} and \code{flags} for taxonomic names matched
    by \code{tnrs_match_names}}
\usage{
\method{ott_id}{match_names}(tax, row_number, taxon_name, ott_id, ...)

\method{flags}{match_names}(tax, row_number, taxon_name, ott_id, ...)

flags(tax, ...)
}
\arguments{
\item{tax}{an object returned by \code{\link{tnrs_match_names}}}

\item{row_number}{the row number corresponding to the name for
which to list the synonyms}

\item{taxon_name}{the taxon name corresponding to the name for
which to list the synonyms}

\item{ott_id}{the ott id corresponding to the name for which to
list the synonyms}

\item{...}{currently ignored}
}
\value{
A list of the ott ids or flags for the taxonomic names
    matched with \code{\link{tnrs_match_names}}, for either one or
    all the names.
}
\description{
\code{rotl} provides a collection of functions that allows users
to extract relevant information from an object generated by
\code{\link{tnrs_match_names}} function.
}
\details{
These methods optionally accept one of the arguments
\code{row_number}, \code{taxon_name} or \code{ott_id} to retrieve
the corresponding information for one of the matches in the object
returned by the \code{\link{tnrs_match_names}} function.

If these arguments are not provided, these methods can return
information for the matches currently listed in the object
returned by \code{\link{tnrs_match_names}}.
}
\examples{
\dontrun{
  rsp <- tnrs_match_names(c("Diadema", "Tyrannosaurus"))
  rsp$ott_id    # ott id for match currently in use
  ott_id(rsp)   # similar as above but elements are named

  ## flags() is useful for instance to determine if a taxon is extinct
  flags(rsp, taxon_name="Tyrannosaurus")
}
}
