% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_p_value.R, R/methods_emmeans.R
\name{p_value}
\alias{p_value}
\alias{p_value.default}
\alias{p_value.emmGrid}
\title{p-values}
\usage{
p_value(model, ...)

\method{p_value}{default}(model, method = NULL, verbose = TRUE, ...)

\method{p_value}{emmGrid}(model, ci = 0.95, adjust = "none", ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed. Only available for models where \code{method = "robust"} is supported.}

\item{method}{If \code{"robust"}, and if model is supported by the \pkg{sandwich} or \pkg{clubSandwich} packages, computes p-values based on robust covariance matrix estimation.}

\item{verbose}{Toggle warnings and messages.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{adjust}{Character value naming the method used to adjust p-values or confidence intervals. See \code{?emmeans::summary.emmGrid} for details.}
}
\value{
A data frame with at least two columns: the parameter names and the p-values. Depending on the model, may also include columns for model components etc.
}
\description{
This function attempts to return, or compute, p-values of a model's parameters. See the documentation for your object's class:
\itemize{
 \item{\link[=p_value.lmerMod]{Mixed models} (\pkg{lme4}, \pkg{nlme}, \pkg{glmmTMB}, ...)}
 \item{\link[=p_value.BFBayesFactor]{Bayesian models} (\pkg{rstanarm}, \pkg{brms}, \pkg{MCMCglmm}, ...)}
 \item{\link[=p_value.zeroinfl]{Zero-inflated models} (\code{hurdle}, \code{zeroinfl}, \code{zerocount}, ...)}
 \item{\link[=p_value.poissonmfx]{Marginal effects models} (\pkg{mfx})}
 \item{\link[=p_value.DirichletRegModel]{Models with special components} (\code{DirichletRegModel}, \code{clm2}, \code{cgam}, ...)}
 }
}
\note{
\code{p_value_robust()} resp. \code{p_value(method = "robust")}
  rely on the \pkg{sandwich} or \pkg{clubSandwich} package (the latter if
  \code{vcov_estimation = "CR"} for cluster-robust standard errors) and will
  thus only work for those models supported by those packages.
}
\examples{
data(iris)
model <- lm(Petal.Length ~ Sepal.Length + Species, data = iris)
p_value(model)
}
