% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{importBrukerFlex}
\alias{importBrukerFlex}
\title{Import Bruker Daltonics *flex files}
\usage{
importBrukerFlex(path, ...)
}
\arguments{
\item{path}{\code{character}, path to directory or file which should be read
in.}

\item{\ldots}{arguments to be passed to
\code{\link[readBrukerFlexData]{readBrukerFlexFile}}.}
}
\value{
a \code{list} of \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects (depending on the
\code{centroided} argument).
}
\description{
This function imports files in Bruker Daltonics *flex-series file format
into \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects.
}
\examples{

library("MALDIquant")
library("MALDIquantForeign")

## get example directory
exampleDirectory <- system.file("exampledata", package="MALDIquantForeign")

s <- importBrukerFlex(exampleDirectory)

}
\references{
\url{https://strimmerlab.github.io/software/maldiquant/}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}},
\code{\link[MALDIquant]{MassPeaks-class}},
\code{\link[readBrukerFlexData]{readBrukerFlexFile}}
}
\author{
Sebastian Gibb
}
