% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-methods.R
\docType{methods}
\name{exportImzMl,MassSpectrum-method}
\alias{exportImzMl,MassSpectrum-method}
\alias{exportImzMl}
\alias{exportImzMl,list-method}
\title{Export to imzML files}
\usage{
\S4method{exportImzMl}{MassSpectrum}(x, file, force=FALSE, processed=TRUE,
coordinates=NULL, pixelSize=c(100, 100), \ldots)

\S4method{exportImzMl}{list}(x, path, force=FALSE, processed=TRUE,
coordinates=NULL, pixelSize=c(100, 100), \ldots)
}
\arguments{
\item{x}{a \code{\link[MALDIquant]{MassSpectrum-class}} object or a
\code{list} of \code{\link[MALDIquant]{MassSpectrum-class}} objects.}

\item{file}{\code{character}, file name.}

\item{force}{\code{logical}, If \code{TRUE} the \code{file} would be
overwritten or \code{path} would be created.}

\item{processed}{\code{logical}, If \code{TRUE} (default) the spectra will
be saved in processed mode (means mass and intensity is stored for each
spectra separately in contrast to continuous mode where the mass is stored
only for one spectrum).}

\item{coordinates}{\code{matrix}, 2 column matrix that contains the x- and
y-coordinates for the spectra.}

\item{pixelSize}{\code{numeric}, a vector of length 2 that contains the x and
y pixel size in micrometers (default: \code{c(100, 100)}).}

\item{path}{\code{character}, path to directory in which the \code{list} of
\code{\link[MALDIquant]{MassSpectrum-class}} would be exported. If
\code{path} is a single filename all spectra will be exported to a single
imzML file.}

\item{\ldots}{arguments to be passed to internal functions.}
}
\description{
This function exports
\code{\link[MALDIquant]{MassSpectrum-class}} objects into imzML files.
}
\examples{

\dontrun{
library("MALDIquant")
library("MALDIquantForeign")

s <- list(createMassSpectrum(mass=1:5, intensity=1:5),
          createMassSpectrum(mass=1:5, intensity=1:5))

## export a list of spectra
exportImzMl(s, path="processed.imzML", coordinates=cbind(x=1:2, y=c(1, 1)))
}

}
\references{
\url{http://strimmerlab.org/software/maldiquant/}

Schramm T, Hester A, Klinkert I, Both J-P, Heeren RMA, Brunelle A,
Laprevote O, Desbenoit N, Robbe M-F, Stoeckli M, Spengler B, Roempp A
(2012)\cr
imzML - A common data format for the flexible exchange and processing of mass
spectrometry imaging data.\cr
Journal of Proteomics 75 (16):5106-5110. \cr
\url{http://dx.doi.org/10.1016/j.jprot.2012.07.026}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}}
}
\author{
Sebastian Gibb
}
