% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_full_citation_graph}
\alias{make_full_citation_graph}
\alias{graph.full.citation}
\alias{full_citation_graph}
\title{Create a complete (full) citation graph}
\usage{
make_full_citation_graph(n, directed = TRUE)

full_citation_graph(...)
}
\arguments{
\item{n}{The number of vertices.}

\item{directed}{Whether to create a directed graph.}

\item{...}{Passed to \code{make_full_citation_graph}.}
}
\value{
An igraph graph.
}
\description{
\code{make_full_citation_graph} creates a full citation graph. This is a
directed graph, where every \code{i->j} edge is present if and only if
\eqn{j<i}. If \code{directed=FALSE} then the graph is just a full graph.
}
\examples{
print_all(make_full_citation_graph(10))
}
\seealso{
Other deterministic constructors: 
\code{\link{graph_from_atlas}()},
\code{\link{graph_from_edgelist}()},
\code{\link{graph_from_literal}()},
\code{\link{make_chordal_ring}()},
\code{\link{make_empty_graph}()},
\code{\link{make_full_graph}()},
\code{\link{make_graph}()},
\code{\link{make_lattice}()},
\code{\link{make_ring}()},
\code{\link{make_star}()},
\code{\link{make_tree}()}
}
\concept{deterministic constructors}
