% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{is_named}
\alias{is_named}
\alias{is.named}
\title{Named graphs}
\usage{
is_named(graph)
}
\arguments{
\item{graph}{The input graph.}
}
\value{
A logical scalar.
}
\description{
An igraph graph is named, if there is a symbolic name associated with its
vertices.
}
\details{
In igraph vertices can always be identified and specified via their numeric
vertex ids. This is, however, not always convenient, and in many cases there
exist symbolic ids that correspond to the vertices. To allow this more
flexible identification of vertices, one can assign a vertex attribute
called \sQuote{name} to an igraph graph. After doing this, the symbolic
vertex names can be used in all igraph functions, instead of the numeric
ids.

Note that the uniqueness of vertex names are currently not enforced in
igraph, you have to check that for yourself, when assigning the vertex
names.
}
\examples{

g <- make_ring(10)
is_named(g)
V(g)$name <- letters[1:10]
is_named(g)
neighbors(g, "a")

}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
