% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-auth-code.R
\name{req_oauth_auth_code}
\alias{req_oauth_auth_code}
\title{OAuth authentication with authorization code}
\usage{
req_oauth_auth_code(
  req,
  client,
  auth_url,
  cache_disk = FALSE,
  cache_key = NULL,
  scope = NULL,
  pkce = TRUE,
  auth_params = list(),
  token_params = list(),
  host_name = "localhost",
  host_ip = "127.0.0.1",
  port = httpuv::randomPort()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{auth_url}{Authorization url; you'll need to discover this by reading
the documentation.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk. Cached tokens are encrypted and
automatically deleted 30 days after creation.}

\item{cache_key}{If you want to cache multiple tokens per app, use this
key to disambiguate them.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{pkce}{Use "Proof Key for Code Exchange"? This adds an extra layer of
security and should always be used if supported by the server.}

\item{auth_params}{List containing additional parameters passed to \code{oauth_flow_auth_code_url()}}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}

\item{host_name}{Host name used to generate \code{redirect_uri}}

\item{host_ip}{IP address web server will be bound to.}

\item{port}{Port to bind web server to. By default, this uses a random port.
You may need to set it to a fixed port if the API requires that the
\code{redirect_uri} specified in the client exactly matches the \code{redirect_uri}
generated by this function.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This uses \code{\link[=oauth_flow_auth_code]{oauth_flow_auth_code()}} to generate an access token, which is
then used to authentication the request with \code{\link[=req_auth_bearer_token]{req_auth_bearer_token()}}.
The token is automatically cached (either in memory or on disk) to minimise
the number of times the flow is performed.
}
\section{Security considerations}{
The authorization code flow is used for both web applications and native
applications (which are equivalent to R packages).
\href{https://datatracker.ietf.org/doc/html/rfc8252}{rfc8252} spells out
important considerations for native apps. Most importantly there's no way
for native apps to keep secrets from their users. This means that the
server should either not require a \code{client_secret} (i.e. a public client
not an confidential client) or ensure that possession of the \code{client_secret}
doesn't bestow any meaningful rights.

Only modern APIs from the bigger players (Azure, Google, etc) explicitly
native apps. However, in most cases, even for older APIs, possessing the
\code{client_secret} gives you no ability to do anything harmful, so our
general principle is that it's fine to include it in an R package, as long
as it's mildly obfuscated to protect it from credential scraping. There's
no incentive to steal your client credentials if it takes less time to
create a new client than find your client secret.
}

\examples{
client <- oauth_client(
  id = "28acfec0674bb3da9f38",
  secret = obfuscated(paste0(
     "J9iiGmyelHltyxqrHXW41ZZPZamyUNxSX1_uKnv",
     "PeinhhxET_7FfUs2X0LLKotXY2bpgOMoHRCo"
  )),
  token_url = "https://github.com/login/oauth/access_token",
  name = "hadley-oauth-test"
)

request("https://api.github.com/user") \%>\%
  req_oauth_auth_code(client, auth_url = "https://github.com/login/oauth/authorize")
}
