% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\name{calc_cv_star}
\alias{calc_cv_star}
\title{Calculate the modified CV from the CV}
\usage{
calc_cv_star(cv)
}
\arguments{
\item{cv}{The CV to modify}
}
\value{
The value of the modified CV
}
\description{
This function calculates the modified coefficient of variation (CV)
based on a (unmodified) CV.
The modified CV is calculated based on the rules in CMH-17-1G. Those
rules are:

\itemize{
  \item{}{For CV < 4\%, CV* = 6\%}
  \item{}{For 4\% <= CV < 8\%, CV* = CV / 2 + 4\%}
  \item{}{For CV > 8\%, CV* = CV}
}
}
\examples{
# The modified CV for values of CV smaller than 4\% is 6\%
calc_cv_star(0.01)
## [1] 0.06

# The modified CV for values of CV larger than 8\% is unchanged
calc_cv_star(0.09)
## [1] 0.09

}
\references{
"Composite Materials Handbook, Volume 1. Polymer Matrix Composites
Guideline for Characterization of Structural Materials,"
SAE International, CMH-17-1G, Mar. 2012.
}
\seealso{
\code{\link{cv}}
}
