% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_contrasts.R
\name{model_list_contrasts}
\alias{model_list_contrasts}
\alias{model_list_contrasts.default}
\title{List contrasts used by a model}
\usage{
model_list_contrasts(model)

\method{model_list_contrasts}{default}(model)
}
\arguments{
\item{model}{a model object}
}
\value{
A tibble with three columns:
\itemize{
\item \code{variable}: variable name
\item \code{contrasts}: contrasts used
\item \code{contrasts_type}: type of contrasts
("treatment", "sum", "poly", "helmert", "sdiff, "other" or "no.contrast")
\item \code{reference}: for variables with treatment, SAS
or sum contrasts, position of the reference level
}
}
\description{
List contrasts used by a model
}
\details{
For models with no intercept, no contrasts will be applied to one of the
categorical variable. In such case, one dummy term will be returned for each
level of the categorical variable.
}
\examples{
glm(
  am ~ mpg + factor(cyl),
  data = mtcars,
  family = binomial,
  contrasts = list(`factor(cyl)` = contr.sum)
) \%>\%
  model_list_contrasts()
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
