% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseMissingPlaceholderForHdf5.R
\name{chooseMissingPlaceholderForHdf5}
\alias{chooseMissingPlaceholderForHdf5}
\alias{missingPlaceholderName}
\alias{addMissingPlaceholderAttributeForHdf5}
\alias{.addMissingStringPlaceholderAttribute}
\alias{.chooseMissingStringPlaceholder}
\title{Choose a missing value placeholder}
\usage{
chooseMissingPlaceholderForHdf5(x, .version = 3)
}
\arguments{
\item{x}{An atomic vector to be saved to HDF5.}

\item{.version}{Internal use only.}
}
\value{
A placeholder value for missing values in \code{x},
guaranteed to not be equal to any non-missing value in \code{x}.
}
\description{
In the \pkg{alabaster.*} framework, we mark missing entries inside HDF5 datasets with placeholder values.
This function chooses a value for the placeholder that does not overlap with anything else in a vector.
}
\details{
For floating-point datasets, the placeholder will not be NA if there are mixtures of NAs and NaNs.
We do not rely on the NaN payload to distinguish between these two values.

Placeholder values are typically saved as scalar attributes on the HDF5 dataset that they are used in.
The usual name of this attribute is \code{"missing-value-placeholder"}, as encoding by \code{missingPlaceholderName}.
}
\examples{
chooseMissingPlaceholderForHdf5(c(TRUE, NA, FALSE))
chooseMissingPlaceholderForHdf5(c(1L, NA, 2L))
chooseMissingPlaceholderForHdf5(c("aaron", NA, "barry"))
chooseMissingPlaceholderForHdf5(c("aaron", NA, "barry", "NA"))
chooseMissingPlaceholderForHdf5(c(1.5, NA, 2.6))
chooseMissingPlaceholderForHdf5(c(1.5, NaN, NA, 2.6))

}
